/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.component;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.fujion.annotation.Component;
import org.fujion.annotation.EventHandler;
import org.fujion.common.MiscUtil;
import org.fujion.component.BaseComponent;
import org.fujion.component.BaseScriptComponent;
import org.fujion.core.WebUtil;
import org.fujion.event.Event;
import org.fujion.event.EventUtil;
import org.fujion.script.IScriptLanguage;
import org.fujion.script.ScriptRegistry;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

@Component(tag="sscript", widgetClass="MetaWidget", content=Component.ContentHandling.AS_ATTRIBUTE, parentTag={"*"}, description="Script source code for server-side invocation.")
public class ServerScript
extends BaseScriptComponent {
    public static final String EVENT_EXECUTED = "scriptExecution";
    private IScriptLanguage scriptLanguage;
    private IScriptLanguage.IParsedScript script;
    private String type;

    public ServerScript() {
        super(false);
    }

    public ServerScript(String type, String script) {
        super(script, false);
        this.setType(type);
    }

    @Override
    protected Object _execute(Map<String, Object> variables) {
        Object result = this.getScript().run(variables);
        EventUtil.post(new Event(EVENT_EXECUTED, (BaseComponent)this, result));
        return result;
    }

    @Override
    public String getSelfName() {
        return this.scriptLanguage == null ? null : this.scriptLanguage.getSelf();
    }

    private IScriptLanguage.IParsedScript getScript() {
        if (this.script == null) {
            Assert.notNull((Object)this.scriptLanguage, () -> "A script type must be specified");
            String code = this.getSrc() == null ? this.getContent() : this.getExternalScript();
            this.script = this.scriptLanguage.parse(code);
        }
        return this.script;
    }

    private void destroyScript() {
        if (this.script != null) {
            this.script.destroy();
            this.script = null;
        }
    }

    private String getExternalScript() {
        try {
            Resource resource = WebUtil.getResource(this.getSrc());
            return IOUtils.toString((InputStream)resource.getInputStream(), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw MiscUtil.toUnchecked((Throwable)e);
        }
    }

    @Override
    public void destroy() {
        this.destroyScript();
        super.destroy();
    }

    @Component.PropertyGetter(value="type", description="The script type.")
    public String getType() {
        return this.type;
    }

    @Component.PropertySetter(value="type", description="The script type.")
    public void setType(String type) {
        IScriptLanguage iScriptLanguage = this.scriptLanguage = (type = this.nullify(type)) == null ? null : (IScriptLanguage)ScriptRegistry.getInstance().get(type);
        if (this.scriptLanguage == null && type != null) {
            throw new IllegalArgumentException("Unknown script type: " + type);
        }
        this.type = type;
        this.propertyChange("type", this.type, this.type, false);
    }

    @EventHandler(value={"propertychange"}, mode={"init"})
    private void onPropertyChanged() {
        this.destroyScript();
    }
}

