/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.component;

import java.util.function.BooleanSupplier;
import org.fujion.ancillary.INamespace;
import org.fujion.annotation.Component;
import org.fujion.annotation.EventHandler;
import org.fujion.client.ExecutionContext;
import org.fujion.component.BaseUIComponent;
import org.fujion.event.Event;
import org.fujion.event.IEventListener;
import org.springframework.util.Assert;

@Component(tag="window", widgetClass="Window", content=Component.ContentHandling.AS_CHILD, parentTag={"*"}, childTag={@Component.ChildTag(value="*")}, description="A window component with a title bar and maximize/minimize/close buttons.")
public class Window
extends BaseUIComponent
implements INamespace {
    private static final IEventListener dummyListener = event -> {};
    private String title;
    private String image;
    private Position position = Position.CENTER;
    private boolean closable;
    private boolean movable = true;
    private boolean sizable;
    private boolean maximizable;
    private boolean minimizable;
    private Size size = Size.NORMAL;
    private BooleanSupplier onCanClose;
    private CloseAction closeAction = CloseAction.DESTROY;
    private Mode mode;
    private IEventListener closeListener;

    public Window() {
        this.setMode(Mode.INLINE);
        this.addClass("flavor:panel-default");
    }

    @Component.PropertyGetter(value="title", description="The title text.")
    public String getTitle() {
        return this.title;
    }

    @Component.PropertySetter(value="title", description="The title text.")
    public void setTitle(String title) {
        this.title = this.nullify(title);
        this.propertyChange("title", this.title, this.title, true);
    }

    @Component.PropertyGetter(value="image", description="The URL of the image to be displayed on the left side of the title bar.")
    public String getImage() {
        return this.image;
    }

    @Component.PropertySetter(value="image", description="The URL of the image to be displayed on the left side of the title bar.")
    public void setImage(String image) {
        this.image = this.nullify(image);
        this.propertyChange("image", this.image, this.image, true);
    }

    @Component.PropertyGetter(value="closable", description="True if the window is closable. A window that is closable has an icon that, when clicked, triggers a close event.")
    public boolean isClosable() {
        return this.closable;
    }

    @Component.PropertySetter(value="closable", defaultValue="false", description="True if the window is closable. A window that is closable has an icon that, when clicked, triggers a close event.")
    public void setClosable(boolean closable) {
        this.closable = closable;
        this.propertyChange("closable", this.closable, (Object)this.closable, true);
    }

    @Component.PropertyGetter(value="sizable", description="The window's sizable property. A window that is sizable has borders that may be dragged to change its dimensions.")
    public boolean isSizable() {
        return this.sizable;
    }

    @Component.PropertySetter(value="sizable", defaultValue="false", description="The window's sizable property. A window that is sizable has borders that may be dragged to change its dimensions.")
    public void setSizable(boolean sizable) {
        this.sizable = sizable;
        this.propertyChange("sizable", this.sizable, (Object)this.sizable, true);
    }

    @Component.PropertyGetter(value="position", description="The placement of a newly opened modal or popup window.")
    public Position getPosition() {
        return this.position;
    }

    @Component.PropertySetter(value="position", defaultValue="center", description="The placement of a newly opened modal or popup window.")
    public void setPosition(Position position) {
        this.position = position;
        this.propertyChange("position", (Object)this.position, (Object)this.position, true);
    }

    @Component.PropertyGetter(value="movable", description="If true, the window may be moved to a new position by dragging its title bar.")
    public boolean isMovable() {
        return this.movable;
    }

    @Component.PropertySetter(value="movable", defaultValue="true", description="If true, the window may be moved to a new position by dragging its title bar.")
    public void setMovable(boolean movable) {
        this.movable = movable;
        this.propertyChange("movable", this.movable, (Object)this.movable, true);
    }

    @Component.PropertyGetter(value="maximizable", description="True if the window may be maximized.")
    public boolean isMaximizable() {
        return this.maximizable;
    }

    @Component.PropertySetter(value="maximizable", defaultValue="false", description="True if the window may be maximized.")
    public void setMaximizable(boolean maximizable) {
        this.maximizable = maximizable;
        this.propertyChange("maximizable", this.maximizable, (Object)this.maximizable, true);
    }

    @Component.PropertyGetter(value="minimizable", description="True if the window may be minimized.")
    public boolean isMinimizable() {
        return this.minimizable;
    }

    @Component.PropertySetter(value="minimizable", defaultValue="false", description="True if the window may be minimized.")
    public void setMinimizable(boolean minimizable) {
        this.minimizable = minimizable;
        this.propertyChange("minimizable", this.minimizable, (Object)this.minimizable, true);
    }

    @Component.PropertyGetter(value="mode", description="The display mode of the window.")
    public Mode getMode() {
        return this.mode;
    }

    @Component.PropertySetter(value="mode", defaultValue="inline", description="The display mode of the window.")
    public void setMode(Mode mode) {
        this.mode = this.defaultify(mode, Mode.INLINE);
        this.propertyChange("mode", (Object)this.mode, (Object)this.mode, true);
    }

    @Component.PropertyGetter(value="size", description="The sizing mode of the window.")
    public Size getSize() {
        return this.size;
    }

    @Component.PropertySetter(value="size", defaultValue="normal", description="The sizing mode of the window.")
    public void setSize(Size size) {
        this.size = this.defaultify(size, Size.NORMAL);
        this.propertyChange("size", (Object)this.size, (Object)this.size, true);
    }

    @Component.PropertyGetter(value="closeAction", description="The action to be taken when the window is closed.")
    public CloseAction getCloseAction() {
        return this.closeAction;
    }

    @Component.PropertySetter(value="closeAction", defaultValue="destroy", description="The action to be taken when the window is closed.")
    public void setCloseAction(CloseAction closeAction) {
        this.closeAction = closeAction == null ? CloseAction.DESTROY : closeAction;
    }

    public boolean close() {
        if (this.canClose()) {
            switch (this.closeAction) {
                case DESTROY: {
                    this.destroy();
                    break;
                }
                case DETACH: {
                    this.detach();
                    break;
                }
                case HIDE: {
                    this.setVisible(false);
                }
            }
            if (this.closeListener != null) {
                try {
                    this.closeListener.onEvent(new Event("close", this));
                }
                finally {
                    this.closeListener = null;
                }
            }
            return true;
        }
        return false;
    }

    public BooleanSupplier getOnCanClose() {
        return this.onCanClose;
    }

    public void setOnCanClose(boolean canClose) {
        this.setOnCanClose(() -> canClose);
    }

    public void setOnCanClose(BooleanSupplier onCanClose) {
        this.onCanClose = onCanClose;
    }

    public boolean canClose() {
        return this.onCanClose == null || this.onCanClose.getAsBoolean();
    }

    public void modal() {
        this.modal(null);
    }

    public void modal(IEventListener closeListener) {
        this.doShow(Mode.MODAL, closeListener);
    }

    public void popup() {
        this.popup(null);
    }

    public void popup(IEventListener closeListener) {
        this.doShow(Mode.POPUP, closeListener);
    }

    private void doShow(Mode mode, IEventListener closeListener) {
        Assert.state((this.closeListener == null ? 1 : 0) != 0, () -> "Window is already open");
        if (this.getParent() == null) {
            this.setParent(ExecutionContext.getPage());
        }
        this.closeListener = closeListener == null ? dummyListener : closeListener;
        this.setMode(mode);
        this.setVisible(true);
        this.fireEvent("open");
    }

    @EventHandler(value={"close"}, syncToClient=false, mode={"init"})
    private void _close() {
        this.close();
    }

    public static enum Position {
        CENTER,
        LEFT_CENTER,
        LEFT_TOP,
        LEFT_BOTTOM,
        RIGHT_CENTER,
        RIGHT_TOP,
        RIGHT_BOTTOM,
        CENTER_TOP,
        CENTER_BOTTOM;

    }

    public static enum CloseAction {
        DETACH,
        DESTROY,
        HIDE;

    }

    public static enum Size {
        NORMAL,
        MAXIMIZED,
        MINIMIZED;

    }

    public static enum Mode {
        MODAL,
        INLINE,
        POPUP;

    }
}

