/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.core;

import java.io.FileNotFoundException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.fujion.client.ExecutionContext;
import org.fujion.common.MiscUtil;
import org.fujion.common.StrUtil;
import org.fujion.core.RequestUtil;
import org.fujion.servlet.DynamicResourceRegistry;
import org.fujion.servlet.WebAppConfiguration;
import org.fujion.webjar.WebJarResourceResolver;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.util.Assert;

public class WebUtil {
    public static final String FUJION_VERSION = WebUtil.class.getPackage().getImplementationVersion();
    public static final String DEFAULT_ETAG = WebUtil.generateETag(FUJION_VERSION);

    public static boolean isDebugEnabled() {
        return WebAppConfiguration.isDebugEnabled();
    }

    public static Map<String, String> queryStringToMap(String queryString) {
        return WebUtil.queryStringToMap(queryString, ",");
    }

    public static Map<String, String> queryStringToMap(String queryString, String valueDelimiter) {
        if (queryString == null || queryString.isEmpty()) {
            return null;
        }
        try {
            valueDelimiter = valueDelimiter == null ? "" : valueDelimiter;
            URI uri = new URI(queryString.startsWith("?") ? queryString : "?" + queryString);
            List params = URLEncodedUtils.parse((URI)uri, (Charset)StrUtil.UTF8);
            HashMap<String, String> result = new HashMap<String, String>();
            for (NameValuePair nvp : params) {
                String value = (String)result.get(nvp.getName());
                result.put(nvp.getName(), (value == null ? "" : value + valueDelimiter) + nvp.getValue());
            }
            return result;
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public static String addQueryString(String url, String queryString) {
        Assert.notNull((Object)url, () -> "The url must not be null");
        if (!StringUtils.isEmpty((String)queryString)) {
            url = url.endsWith("?") ? url + queryString : (url.contains("?") ? url + "&" + queryString : url + "?" + queryString);
        }
        return url;
    }

    public static String getQueryParams() {
        String requestUrl = WebUtil.getRequestUrl();
        int i = requestUrl == null ? -1 : requestUrl.indexOf("?");
        return i == -1 ? "" : requestUrl.substring(i + 1);
    }

    public static String getRequestUrl() {
        return ExecutionContext.getPage().getBrowserInfo("requestURL");
    }

    public static String getBaseUrl() {
        String url = WebUtil.getRequestUrl();
        String path = ExecutionContext.getServletContext().getContextPath();
        int i = url.indexOf(path);
        return url.substring(0, i + path.length()) + "/";
    }

    public static Cookie getCookie(String cookieName) {
        return WebUtil.getCookie(cookieName, RequestUtil.getRequest());
    }

    public static Cookie getCookie(String cookieName, HttpServletRequest request) {
        Assert.notNull((Object)cookieName, () -> "The cookie name must not be null");
        Assert.notNull((Object)request, () -> "The request must not be null");
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : request.getCookies()) {
                if (!cookieName.equals(cookie.getName())) continue;
                return cookie;
            }
        }
        return null;
    }

    public static String getCookieValue(String cookieName) {
        return WebUtil.getCookieValue(cookieName, RequestUtil.getRequest());
    }

    public static String getCookieValue(String cookieName, HttpServletRequest request) {
        Cookie cookie = WebUtil.getCookie(cookieName, request);
        return cookie == null ? null : WebUtil.decodeCookieValue(cookie.getValue());
    }

    public static String encodeCookieValue(String cookieValuePlainText) {
        Assert.notNull((Object)cookieValuePlainText, () -> "The cookieValuePlainText must not be null");
        try {
            return URLEncoder.encode(Base64.encodeBase64String((byte[])cookieValuePlainText.getBytes()), "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected exception occurred encoding cookie value", e);
        }
    }

    public static String decodeCookieValue(String encodedCookieValue) {
        Assert.notNull((Object)encodedCookieValue, () -> "The encodedCookieValue must not be null");
        try {
            return new String(Base64.decodeBase64((String)URLDecoder.decode(encodedCookieValue, "UTF-8")));
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected exception occurred decoding cookie value", e);
        }
    }

    public static Cookie setCookie(String cookieName, String value, HttpServletResponse response, HttpServletRequest request) {
        Assert.notNull((Object)response, () -> "The response must not be null");
        Cookie cookie = WebUtil.getCookie(cookieName, request);
        if (value != null) {
            value = WebUtil.encodeCookieValue(value);
        }
        if (cookie == null) {
            if (value == null) {
                return null;
            }
            cookie = new Cookie(cookieName, value);
        } else if (value == null) {
            cookie.setMaxAge(0);
        } else {
            cookie.setValue(value);
        }
        if (request.isSecure()) {
            cookie.setSecure(true);
        }
        response.addCookie(cookie);
        return cookie;
    }

    public static Resource getResource(String src) {
        return WebUtil.getResource(src, ExecutionContext.getServletContext());
    }

    public static Resource getResource(String src, ServletContext ctx) {
        try {
            Resource resource;
            if (src.startsWith("dynamic/") || src.startsWith("/dynamic/")) {
                String path = StringUtils.substringAfter((String)src, (String)"dynamic/");
                resource = DynamicResourceRegistry.getInstance().getResource(path);
            } else if (src.startsWith("web/") || src.startsWith("/web/")) {
                resource = new ClassPathResource(src);
            } else if (src.matches("^.*\\:\\/.*")) {
                resource = new UrlResource(src);
            } else {
                String string = src = src.startsWith("/") ? src : "/" + src;
                if (src.startsWith("/webjars/")) {
                    src = "/webjars/" + WebJarResourceResolver.getResourcePath(src.substring(9));
                }
                URL url = ctx == null ? null : ctx.getResource(src);
                UrlResource urlResource = resource = url == null ? null : new UrlResource(url);
            }
            if (resource == null || !resource.exists()) {
                throw new FileNotFoundException(src);
            }
            return resource;
        }
        catch (Exception e) {
            throw MiscUtil.toUnchecked((Throwable)e);
        }
    }

    public static void disableCache(HttpServletResponse response) {
        response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", 0L);
    }

    public static String formatETag(String etag, boolean weak) {
        if ((etag = StringUtils.trimToNull((String)etag)) == null || etag.startsWith("\"") || etag.startsWith("W/\"")) {
            return etag;
        }
        return (weak ? "W/" : "") + StrUtil.enquoteDouble((String)etag);
    }

    public static String addETag(HttpServletResponse response, String etag, boolean weak) {
        response.setHeader("ETag", WebUtil.formatETag(etag, weak));
        return WebUtil.getETag(response);
    }

    public static String getETag(HttpServletRequest request) {
        return request.getHeader("If-None-Match");
    }

    public static String getETag(HttpServletResponse response) {
        return response.getHeader("ETag");
    }

    public static boolean sameETag(HttpServletRequest request, HttpServletResponse response) {
        return WebUtil.sameETag(WebUtil.getETag(request), WebUtil.getETag(response));
    }

    public static boolean sameETag(String requestETag, String responseETag) {
        requestETag = StringUtils.removeStart((String)requestETag, (String)"W/");
        responseETag = StringUtils.removeStart((String)responseETag, (String)"W/");
        return requestETag != null && ("*".equals(requestETag) || requestETag.equals(responseETag));
    }

    public static String generateETag(String value) {
        return (value = StringUtils.trimToNull((String)value)) == null || value.contains("SNAPSHOT") ? WebUtil.randomETag() : DigestUtils.md5Hex((String)value);
    }

    public static String randomETag() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    private WebUtil() {
    }
}

