/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.expression;

import org.fujion.common.AbstractCache;
import org.springframework.expression.Expression;
import org.springframework.expression.ParserContext;
import org.springframework.expression.common.TemplateParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;

public class ExpressionCache
extends AbstractCache<String, Expression> {
    private static final ExpressionCache instance = new ExpressionCache();
    private final SpelExpressionParser parser = new SpelExpressionParser();
    private final ParserContext templateContext = new TemplateParserContext("${", "}");

    public static ExpressionCache getInstance() {
        return instance;
    }

    private ExpressionCache() {
    }

    protected Expression fetch(String expression) {
        return this.parser.parseExpression(expression, this.templateContext);
    }

    protected boolean hasExpression(String value) {
        return value != null && value.contains(this.templateContext.getExpressionPrefix());
    }
}

