/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.jmx;

import com.udojava.jmx.wrapper.JMXBean;
import com.udojava.jmx.wrapper.JMXBeanAttribute;
import com.udojava.jmx.wrapper.JMXBeanOperation;
import org.fujion.common.StrUtil;
import org.fujion.expression.ExpressionCache;
import org.fujion.jmx.JMXConsole;
import org.fujion.page.PageDefinitionCache;

@JMXBean(resourceBundleName="org.fujion.common.MessageBundle", descriptionKey="org.fujion.console.cache.description", sorted=true)
public class CacheManagementConsole
implements JMXConsole.IJMXConsolePlugin {
    private final PageDefinitionCache fspCache = PageDefinitionCache.getInstance();
    private final ExpressionCache elCache = ExpressionCache.getInstance();

    @Override
    public String getType() {
        return "Cache Manager";
    }

    @JMXBeanAttribute(sortValue="10", nameKey="org.fujion.console.cache.fsp.size.name", descriptionKey="org.fujion.console.cache.fsp.size.description")
    public String getFSPCacheSize() {
        int size = this.fspCache.size();
        return this.formatResult("fsp.size", size);
    }

    @JMXBeanOperation(sortValue="11", nameKey="org.fujion.console.cache.fsp.clear.name", impactType=JMXBeanOperation.IMPACT_TYPES.ACTION, descriptionKey="org.fujion.console.cache.fsp.clear.description")
    public String clearFSPCache() {
        int size = this.fspCache.size();
        this.fspCache.clear();
        return this.formatResult("fsp.clear", size);
    }

    @JMXBeanOperation(sortValue="12", nameKey="org.fujion.console.cache.fsp.refresh.name", impactType=JMXBeanOperation.IMPACT_TYPES.ACTION, descriptionKey="org.fujion.console.cache.fsp.refresh.description")
    public String refreshFSPCache() {
        int size = this.fspCache.size();
        this.fspCache.refresh();
        return this.formatResult("fsp.refresh", size);
    }

    @JMXBeanAttribute(sortValue="20", nameKey="org.fujion.console.cache.exp.size.name", descriptionKey="org.fujion.console.cache.exp.size.description")
    public String getELCacheSize() {
        int size = this.elCache.size();
        return this.formatResult("exp.size", size);
    }

    @JMXBeanOperation(sortValue="21", nameKey="org.fujion.console.cache.exp.clear.name", impactType=JMXBeanOperation.IMPACT_TYPES.ACTION, descriptionKey="org.fujion.console.cache.exp.clear.description")
    public String clearELCache() {
        int size = this.elCache.size();
        this.elCache.clear();
        return this.formatResult("exp.clear", size);
    }

    private String formatResult(String id, Object ... args) {
        return StrUtil.getLabel((String)("org.fujion.console.cache." + id + ".result"), (Object[])args);
    }
}

