/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.jmx;

import com.udojava.jmx.wrapper.JMXBean;
import com.udojava.jmx.wrapper.JMXBeanWrapper;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.fujion.common.MiscUtil;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.DestructionAwareBeanPostProcessor;

public class JMXConsole
implements DestructionAwareBeanPostProcessor {
    private final MBeanServer mbs;

    private JMXConsole(boolean enabled) {
        this.mbs = enabled ? ManagementFactory.getPlatformMBeanServer() : null;
    }

    public void registerPlugin(IJMXConsolePlugin plugin) {
        if (this.mbs != null) {
            try {
                IJMXConsolePlugin mbean = plugin.getClass().isAnnotationPresent(JMXBean.class) ? new JMXBeanWrapper((Object)plugin) : plugin;
                this.mbs.registerMBean(mbean, this.getObjectName(plugin));
            }
            catch (Exception e) {
                throw MiscUtil.toUnchecked((Throwable)e);
            }
        }
    }

    public void unregisterPlugin(IJMXConsolePlugin plugin) {
        if (this.mbs != null) {
            try {
                this.mbs.unregisterMBean(this.getObjectName(plugin));
            }
            catch (Exception e) {
                throw MiscUtil.toUnchecked((Throwable)e);
            }
        }
    }

    private ObjectName getObjectName(IJMXConsolePlugin plugin) throws MalformedObjectNameException {
        return new ObjectName("org.fujion:type=" + plugin.getType());
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (this.mbs != null && bean instanceof IJMXConsolePlugin) {
            this.registerPlugin((IJMXConsolePlugin)bean);
        }
        return bean;
    }

    public void postProcessBeforeDestruction(Object bean, String beanName) throws BeansException {
        if (this.mbs != null && bean instanceof IJMXConsolePlugin) {
            this.unregisterPlugin((IJMXConsolePlugin)bean);
        }
    }

    public static interface IJMXConsolePlugin {
        public String getType();
    }
}

