/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.logging;

import java.util.Map;
import org.fujion.client.ClientRequest;
import org.fujion.common.Logger;
import org.fujion.logging.LogUtil;
import org.fujion.websocket.IRequestHandler;

public class LogRequestHandler
implements IRequestHandler {
    private static final Logger log = Logger.create(LogRequestHandler.class);

    @Override
    public void handleRequest(ClientRequest request) {
        Map data = request.getData(Map.class);
        String level = (String)data.get("level");
        Object message = data.get("message");
        switch (LogUtil.toLevel(level)) {
            case DEBUG: {
                log.debug(message);
                break;
            }
            case ERROR: {
                log.error(message);
                break;
            }
            case FATAL: {
                log.fatal(message);
                break;
            }
            case INFO: {
                log.info(message);
                break;
            }
            case TRACE: {
                log.trace(message);
                break;
            }
            case WARN: {
                log.warn(message);
                break;
            }
            default: {
                log.info(() -> "Unknown logging level: " + level);
                log.info(message);
            }
        }
    }

    @Override
    public String getRequestType() {
        return "log";
    }
}

