/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.page;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.fujion.ancillary.ComponentException;
import org.fujion.ancillary.DeferredInvocation;
import org.fujion.annotation.ComponentDefinition;
import org.fujion.component.BaseComponent;
import org.fujion.component.Page;
import org.fujion.expression.ELContext;
import org.fujion.expression.ELEvaluator;
import org.fujion.page.PageElement;

public class PageDefinition {
    private final PageElement root = new PageElement(null, null);
    private String source;

    public PageElement getRootElement() {
        return this.root;
    }

    public String getSource() {
        return this.source;
    }

    void setSource(String source) {
        this.source = source;
    }

    public List<BaseComponent> materialize(BaseComponent parent) {
        return this.materialize(parent, null);
    }

    public List<BaseComponent> materialize(BaseComponent parent, Map<String, Object> args) {
        try {
            ArrayList deferrals = new ArrayList();
            ArrayList<BaseComponent> created = new ArrayList<BaseComponent>();
            List<PageElement> children = this.root.getChildren();
            if (!(parent instanceof Page) && children.size() == 1 && children.get(0).getDefinition().getComponentClass() == Page.class) {
                children = children.get(0).getChildren();
            }
            this.materialize(children, parent, deferrals, args, created);
            for (DeferredInvocation deferredInvocation : deferrals) {
                deferredInvocation.invoke(new Object[0]);
            }
            return created;
        }
        catch (Exception e) {
            throw new ComponentException((Throwable)e, "Exception materializing page definition \"%s\"", this.source);
        }
    }

    private void materialize(Iterable<PageElement> children, BaseComponent parent, List<DeferredInvocation<?>> deferrals, Map<String, Object> args, List<BaseComponent> created) {
        if (children != null) {
            for (PageElement child : children) {
                List<BaseComponent> components = this.materialize(child, parent, deferrals, args);
                if (created == null) continue;
                for (BaseComponent component : components) {
                    if (args != null && !args.isEmpty()) {
                        component.getAttributes().putAll(args);
                    }
                    created.add(component);
                }
            }
        }
    }

    private List<BaseComponent> materialize(PageElement element, BaseComponent parent, List<DeferredInvocation<?>> deferrals, Map<String, Object> args) {
        List<BaseComponent> components;
        ComponentDefinition def = element.getDefinition();
        boolean merge = parent instanceof Page && def.getComponentClass() == Page.class;
        Map<String, String> attributes = element.getAttributes();
        if (merge) {
            components = Collections.singletonList(parent);
            parent = null;
        } else {
            ELContext elContext = attributes.isEmpty() ? null : new ELContext(null, parent, element, args);
            components = def.getFactory().create(attributes, elContext);
        }
        for (BaseComponent component : components) {
            if (!attributes.isEmpty()) {
                ELContext elContext = new ELContext(component, parent, element, args);
                for (Map.Entry<String, String> attribute : attributes.entrySet()) {
                    Object value = ELEvaluator.getInstance().evaluate(attribute.getValue(), elContext);
                    DeferredInvocation<?> deferral = def.setProperty(component, attribute.getKey(), value);
                    if (deferral == null) continue;
                    deferrals.add(deferral);
                }
            }
            if (parent != null) {
                parent.addChild(component);
            }
            this.materialize(element.getChildren(), component, deferrals, args, null);
        }
        return components;
    }
}

