/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.page;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletContext;
import org.fujion.common.MiscUtil;
import org.fujion.common.XMLUtil;
import org.fujion.core.WebUtil;
import org.fujion.page.ParserException;
import org.springframework.core.io.Resource;
import org.w3c.dom.Document;

public class PageSource {
    private final String source;
    private InputStream stream;
    private Document document;

    public PageSource(String src) {
        this(WebUtil.getResource(src));
    }

    public PageSource(String src, ServletContext ctx) {
        this(WebUtil.getResource(src, ctx));
    }

    public PageSource(Resource resource) {
        try {
            String src = resource.getFilename();
            this.source = src == null ? resource.getDescription() : src;
            this.stream = resource.getInputStream();
        }
        catch (IOException e) {
            throw MiscUtil.toUnchecked((Throwable)e);
        }
    }

    public PageSource(InputStream stream) {
        this(stream, "<unknown>");
    }

    public PageSource(InputStream stream, String src) {
        this.stream = stream;
        this.source = src;
    }

    public Document getDocument() {
        if (this.document == null) {
            try (InputStream is = this.stream;){
                this.stream = null;
                this.document = XMLUtil.newDocumentBuilder((boolean)true).parse(is);
            }
            catch (Exception e) {
                throw new ParserException(e, "Exception parsing resource \"%s\"", this.source);
            }
        }
        return this.document;
    }

    public String getSource() {
        return this.source;
    }
}

