/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.servlet;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;
import org.fujion.core.WebUtil;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.web.servlet.resource.HttpResource;

public class ETaggedResource
implements HttpResource {
    private final Resource resource;
    private final HttpHeaders headers;
    private final boolean match;

    public static Resource create(Resource resource, HttpServletRequest request, String responseETag) {
        responseETag = WebUtil.formatETag(responseETag, false);
        boolean match = WebUtil.sameETag(WebUtil.getETag(request), responseETag);
        return new ETaggedResource(resource, responseETag, match);
    }

    private ETaggedResource(Resource resource, String responseETag, boolean match) {
        this.resource = resource;
        this.match = match;
        this.headers = resource instanceof HttpResource ? ((HttpResource)resource).getResponseHeaders() : new HttpHeaders();
        this.headers.setETag(WebUtil.formatETag(responseETag, false));
    }

    public boolean exists() {
        return this.resource.exists();
    }

    public URL getURL() throws IOException {
        return this.resource.getURL();
    }

    public URI getURI() throws IOException {
        return this.resource.getURI();
    }

    public File getFile() throws IOException {
        return this.resource.getFile();
    }

    public long contentLength() throws IOException {
        return this.resource.contentLength();
    }

    public long lastModified() throws IOException {
        if (this.match) {
            throw new ResourceNotModifiedException(this.headers.getETag());
        }
        return -1L;
    }

    public Resource createRelative(String relativePath) throws IOException {
        return this.resource.createRelative(relativePath);
    }

    public String getFilename() {
        return this.resource.getFilename();
    }

    public String getDescription() {
        return this.resource.getDescription();
    }

    public InputStream getInputStream() throws IOException {
        return this.resource.getInputStream();
    }

    public HttpHeaders getResponseHeaders() {
        return this.headers;
    }

    public static class ResourceNotModifiedException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private final String etag;

        ResourceNotModifiedException(String etag) {
            this.etag = etag;
        }

        public String getETag() {
            return this.etag;
        }
    }
}

