/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.servlet;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.fujion.core.WebUtil;
import org.fujion.servlet.ETaggedResource;
import org.springframework.core.io.Resource;
import org.springframework.util.StreamUtils;
import org.springframework.web.servlet.resource.AbstractResourceResolver;
import org.springframework.web.servlet.resource.ResourceResolverChain;

public class EmptyResourceResolver
extends AbstractResourceResolver {
    private static final String ETAG = WebUtil.generateETag("empty");

    protected Resource resolveResourceInternal(HttpServletRequest request, String requestPath, List<? extends Resource> locations, ResourceResolverChain chain) {
        return ETaggedResource.create(new EmptyResource(requestPath), request, ETAG);
    }

    protected String resolveUrlPathInternal(String resourceUrlPath, List<? extends Resource> locations, ResourceResolverChain chain) {
        return chain.resolveUrlPath(resourceUrlPath, locations);
    }

    private static class EmptyResource
    implements Resource {
        private final String path;

        EmptyResource(String path) {
            this.path = path;
        }

        public InputStream getInputStream() throws IOException {
            return StreamUtils.emptyInput();
        }

        public boolean exists() {
            return true;
        }

        public URL getURL() throws IOException {
            return null;
        }

        public URI getURI() throws IOException {
            return null;
        }

        public File getFile() throws IOException {
            return new File(this.path);
        }

        public long contentLength() throws IOException {
            return 0L;
        }

        public long lastModified() throws IOException {
            return -1L;
        }

        public Resource createRelative(String relativePath) throws IOException {
            return null;
        }

        public String getFilename() {
            return this.path;
        }

        public String getDescription() {
            return null;
        }
    }
}

