/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.spring;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Properties;
import org.fujion.common.Localizer;
import org.fujion.common.Logger;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class ClasspathMessageSource
extends ReloadableResourceBundleMessageSource {
    private static final Logger log = Logger.create(ClasspathMessageSource.class);
    private static final String PROPERTIES_SUFFIX = ".properties";
    private static final PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
    private static final ClasspathMessageSource instance = new ClasspathMessageSource();

    public static ClasspathMessageSource getInstance() {
        return instance;
    }

    private ClasspathMessageSource() {
        this.setBasenames(new String[]{"WEB-INF/messages", "classpath*:/**/messages"});
        this.setDefaultEncoding(StandardCharsets.UTF_8.name());
        Localizer.registerMessageSource((id, locale, args) -> this.getMessage(id, args, locale));
    }

    protected ReloadableResourceBundleMessageSource.PropertiesHolder refreshProperties(String filename, ReloadableResourceBundleMessageSource.PropertiesHolder propHolder) {
        if (filename.startsWith("classpath*:")) {
            return this.refreshClassPathProperties(filename, propHolder);
        }
        return super.refreshProperties(filename, propHolder);
    }

    private ReloadableResourceBundleMessageSource.PropertiesHolder refreshClassPathProperties(String filename, ReloadableResourceBundleMessageSource.PropertiesHolder propHolder) {
        Properties properties = new Properties();
        long lastModified = -1L;
        try {
            Resource[] resources;
            for (Resource resource : resources = resolver.getResources(filename + PROPERTIES_SUFFIX)) {
                String sourcePath = resource.getURI().toString().replace(PROPERTIES_SUFFIX, "");
                ReloadableResourceBundleMessageSource.PropertiesHolder holder = super.refreshProperties(sourcePath, propHolder);
                properties.putAll((Map<?, ?>)holder.getProperties());
                lastModified = Math.min(lastModified, resource.lastModified());
            }
        }
        catch (Exception e) {
            log.warn(() -> "Error reading message source: " + filename);
        }
        return new ReloadableResourceBundleMessageSource.PropertiesHolder((ReloadableResourceBundleMessageSource)this, properties, lastModified);
    }
}

