/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.taglib;

import java.io.IOException;
import java.io.InputStream;
import org.fujion.common.MiscUtil;
import org.fujion.common.XMLUtil;
import org.fujion.core.WebUtil;
import org.fujion.taglib.TagLibrary;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TagLibraryParser {
    private static final TagLibraryParser instance = new TagLibraryParser();

    public static TagLibraryParser getInstance() {
        return instance;
    }

    private TagLibraryParser() {
    }

    public TagLibrary parse(String src) {
        return this.parse(WebUtil.getResource(src));
    }

    public TagLibrary parse(Resource resource) {
        try {
            return this.parse(resource.getInputStream());
        }
        catch (IOException e) {
            throw MiscUtil.toUnchecked((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TagLibrary parse(InputStream stream) {
        try (InputStream is = stream;){
            Element root = XMLUtil.parseXMLFromStream((InputStream)is).getDocumentElement();
            String uri = this.getValue(root, "uri");
            NodeList nodes = root.getElementsByTagName("function");
            int nodeCount = nodes.getLength();
            TagLibrary tagLibrary = new TagLibrary(uri);
            for (int i = 0; i < nodeCount; ++i) {
                Element ele = (Element)nodes.item(i);
                String name = this.getValue(ele, "name");
                String clazz = this.getValue(ele, "function-class");
                String signature = this.getValue(ele, "function-signature");
                tagLibrary.addFunction(name, clazz, signature);
            }
            TagLibrary tagLibrary2 = tagLibrary;
            return tagLibrary2;
        }
        catch (Exception e) {
            throw MiscUtil.toUnchecked((Throwable)e);
        }
    }

    private String getValue(Element ele, String tag) {
        NodeList nodes = ele.getElementsByTagName(tag);
        Assert.state((nodes.getLength() > 0 ? 1 : 0) != 0, () -> "Tag library definition missing attribute: " + tag);
        return nodes.item(0).getTextContent().trim();
    }
}

