/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.theme;

import org.fujion.common.AbstractRegistry;
import org.fujion.common.Logger;
import org.fujion.theme.Theme;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class ThemeRegistry
extends AbstractRegistry<String, Theme>
implements BeanPostProcessor {
    private static final Logger log = Logger.create(ThemeRegistry.class);
    private static final ThemeRegistry instance = new ThemeRegistry();

    public static ThemeRegistry getInstance() {
        return instance;
    }

    protected String getKey(Theme theme) {
        return theme.getName();
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof Theme) {
            Theme newTheme = (Theme)bean;
            String themeName = newTheme.getName();
            Theme oldTheme = (Theme)this.get(themeName);
            if (oldTheme != null) {
                oldTheme.merge(newTheme);
                return oldTheme;
            }
            this.register(newTheme);
            log.info(() -> "Registered theme: " + themeName);
        }
        return bean;
    }
}

