/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.theme;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.fujion.theme.Theme;
import org.fujion.theme.ThemeRegistry;
import org.fujion.theme.ThemeResolvers;
import org.springframework.web.servlet.ThemeResolver;

public class ThemeServletFilter
implements Filter {
    private final ThemeResolver themeResolver = ThemeResolvers.getInstance();

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String themeName = this.themeResolver.resolveThemeName(httpRequest);
        Theme theme = (Theme)ThemeRegistry.getInstance().get(themeName);
        if (theme != null) {
            String requestPath;
            String originalPath = httpRequest.getPathInfo();
            String string = requestPath = originalPath == null ? null : theme.translatePath(originalPath);
            if (requestPath != null) {
                requestPath = requestPath.isEmpty() ? "empty/" + originalPath : requestPath;
                httpRequest.getRequestDispatcher(requestPath).forward((ServletRequest)httpRequest, response);
                return;
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

