/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.webjar;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.fujion.core.WebUtil;
import org.fujion.servlet.ETaggedResource;
import org.fujion.webjar.WebJar;
import org.fujion.webjar.WebJarLocator;
import org.springframework.core.io.Resource;
import org.springframework.web.servlet.resource.AbstractResourceResolver;
import org.springframework.web.servlet.resource.ResourceResolverChain;

public class WebJarResourceResolver
extends AbstractResourceResolver {
    public static String getResourcePath(String path) {
        int i = path.indexOf("/");
        String name = path.substring(0, i);
        int j = path.indexOf("/", i + 1);
        String version = j < 0 ? "" : path.substring(i + 1, j);
        WebJar webjar = WebJarLocator.getInstance().getWebjar(name);
        if (webjar != null && !version.equals(webjar.getVersion())) {
            path = name + "/" + webjar.getVersion() + path.substring(i);
        }
        return path;
    }

    protected Resource resolveResourceInternal(HttpServletRequest request, String requestPath, List<? extends Resource> locations, ResourceResolverChain chain) {
        String newPath = WebJarResourceResolver.getResourcePath(requestPath);
        Resource resource = chain.resolveResource(request, newPath, locations);
        if (resource != null) {
            String etag = WebUtil.generateETag(newPath) + (WebUtil.isDebugEnabled() ? "@debug@" : "");
            resource = ETaggedResource.create(resource, request, etag);
        }
        return resource;
    }

    protected String resolveUrlPathInternal(String resourceUrlPath, List<? extends Resource> locations, ResourceResolverChain chain) {
        String newPath = WebJarResourceResolver.getResourcePath(resourceUrlPath);
        return chain.resolveUrlPath(newPath, locations);
    }
}

