/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.websocket;

import org.fujion.ancillary.OptionMap;
import org.fujion.client.ClientOptions;
import org.fujion.client.ClientRequest;
import org.fujion.client.Synchronizer;
import org.fujion.component.Page;
import org.fujion.page.PageDefinition;
import org.fujion.page.PageDefinitionCache;
import org.fujion.websocket.IRequestHandler;
import org.fujion.websocket.SessionInitException;
import org.fujion.websocket.Sessions;

public class InitRequestHandler
implements IRequestHandler {
    private final OptionMap clientOptionMap = ClientOptions.getInstance().toMap();

    @Override
    public void handleRequest(ClientRequest request) {
        Page page = request.getPage();
        PageDefinition pageDefinition = PageDefinitionCache.getInstance().get(page.getSrc());
        Synchronizer synchronizer = request.getSession().getSynchronizer();
        synchronizer.startQueueing();
        Page._init(page, request, synchronizer);
        Sessions.getInstance().notifyLifecycleListeners(request.getSession(), true);
        try {
            page.invoke("beforeInitialize", this.clientOptionMap);
            pageDefinition.materialize(page);
            page.invoke("afterInitialize", new Object[0]);
            page.fireEvent("afterInitialize");
        }
        catch (Exception e) {
            synchronizer.clear();
            throw new SessionInitException(e);
        }
        finally {
            synchronizer.stopQueueing();
        }
    }

    @Override
    public String getRequestType() {
        return "init";
    }
}

