/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.gmaps;

import org.fujion.annotation.Component;
import org.fujion.annotation.EventHandler;
import org.fujion.component.BaseUIComponent;
import org.fujion.gmaps.LatLng;
import org.fujion.gmaps.LatLngBounds;
import org.fujion.gmaps.LoaderOptions;
import org.fujion.gmaps.MapOptions;
import org.fujion.gmaps.TiltAngle;
import org.fujion.gmaps.event.CenterChangeEvent;
import org.fujion.gmaps.event.HeadingChangeEvent;
import org.fujion.gmaps.event.MapTypeIdChangeEvent;
import org.fujion.gmaps.event.TiltChangeEvent;
import org.fujion.gmaps.event.ZoomChangeEvent;
import org.springframework.util.Assert;

@Component(tag="gmap", widgetModule="fujion-gmaps", widgetClass="GMap", parentTag={"*"}, description="Google Maps component.")
public class GoogleMap
extends BaseUIComponent {
    private boolean running;
    private final MapOptions options = new MapOptions();

    public void run() {
        this.invoke("run", new Object[]{this.options, LoaderOptions.getInstance().validate()});
        this.running = true;
    }

    public void clear() {
        this.invoke("clear", new Object[0]);
        this.running = false;
    }

    private void ensureRunning() {
        Assert.state((boolean)this.running, (String)"A map has not yet been created.");
    }

    public MapOptions getOptions() {
        return this.options;
    }

    public void panBy(double x, double y) {
        this.invokeMap("panBy", x, y);
    }

    public void panTo(LatLng center) {
        this.invokeMap("panTo", new Object[]{center});
    }

    public void panToBounds(LatLngBounds bounds) {
        this.invokeMap("panToBounds", new Object[]{bounds});
    }

    private void invokeMap(String function, Object ... args) {
        this.ensureRunning();
        this.invoke("invoke", new Object[]{function, args});
    }

    @Component.PropertyGetter(value="center", description="The latitude and longitude of the current center of the map.")
    public LatLng getCenter() {
        return this.options.center;
    }

    public void setCenter(LatLng center) {
        this.options.center = center;
        this.propertyChange("center", (Object)this.options.center, (Object)this.options.center, this.running);
    }

    @Component.PropertySetter(value="center", description="The latitude and longitude of the current center of the map.")
    private void setCenter(String center) {
        this.setCenter(LatLng.parse(center));
    }

    @Component.PropertyGetter(value="tilt", description="Controls the automatic switching behavior for the angle of incidence of the map.")
    public TiltAngle getTilt() {
        return this.options.tilt;
    }

    @Component.PropertySetter(value="tilt", description="Controls the automatic switching behavior for the angle of incidence of the map.")
    public void setTilt(TiltAngle tilt) {
        this.options.tilt = tilt;
        this.propertyChange("tilt", (Object)this.options.tilt, (Object)this.options.tilt, this.running);
    }

    @Component.PropertyGetter(value="zoom", description="The zoom value.")
    public int getZoom() {
        return this.options.zoom;
    }

    @Component.PropertySetter(value="zoom", description="The zoom value.")
    public void setZoom(int zoom) {
        this.options.zoom = zoom;
        this.propertyChange("zoom", this.options.zoom, this.options.zoom, this.running);
    }

    @EventHandler(value={"gmap_tilt_changed"})
    private void _onTiltChanged(TiltChangeEvent event) {
        this.options.tilt = event.getTilt();
        this.propertyChange("tilt", (Object)this.options.tilt, (Object)this.options.tilt, false);
    }

    @EventHandler(value={"gmap_zoom_changed"})
    private void _onZoomChanged(ZoomChangeEvent event) {
        this.options.zoom = event.getZoom();
        this.propertyChange("zoom", this.options.zoom, this.options.zoom, false);
    }

    @EventHandler(value={"gmap_center_changed"})
    private void _onCenterChanged(CenterChangeEvent event) {
        this.options.center = event.getLocation();
    }

    @EventHandler(value={"gmap_heading_changed"})
    private void _onHeadingChanged(HeadingChangeEvent event) {
        this.options.heading = event.getHeading();
    }

    @EventHandler(value={"gmap_maptypeid_changed"})
    private void _onMapTypeIdChanged(MapTypeIdChangeEvent event) {
        this.options.mapTypeId$enum = event.getMapTypeIdEnum();
        this.options.mapTypeId$string = this.options.mapTypeId$enum == null ? event.getMapTypeIdString() : null;
    }
}

