/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.gmaps;

import java.util.Objects;
import org.fujion.ancillary.Options;
import org.fujion.annotation.Option;
import org.fujion.gmaps.LatLng;

public class LatLngBounds
extends Options {
    @Option
    protected LatLng sw;
    @Option
    protected LatLng ne;

    public LatLngBounds(LatLng sw, LatLng ne) {
        this.sw = sw;
        this.ne = ne;
    }

    public LatLngBounds(double north, double south, double east, double west) {
        this.sw = new LatLng(south, west);
        this.ne = new LatLng(north, east);
    }

    public boolean contains(LatLng point) {
        return point.lat >= this.sw.lat && point.lat <= this.ne.lat && point.lng >= this.sw.lng && point.lng <= this.ne.lng;
    }

    public void extend(LatLng point) {
        if (point.lat < this.sw.lat) {
            this.sw.lat = point.lat;
        } else if (point.lat > this.ne.lat) {
            this.ne.lat = point.lat;
        }
        if (point.lng < this.sw.lng) {
            this.sw.lng = point.lng;
        } else if (point.lng > this.ne.lng) {
            this.ne.lng = point.lng;
        }
    }

    public LatLng getCenter() {
        double lat = (this.ne.lat + this.sw.lat) / 2.0;
        double lng = (this.ne.lng + this.sw.lng) / 2.0;
        return new LatLng(lat, lng);
    }

    public LatLng getNortheast() {
        return this.ne;
    }

    public LatLng getSouthwest() {
        return this.sw;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof LatLngBounds) {
            LatLngBounds b = (LatLngBounds)((Object)o);
            return Objects.equals((Object)this.sw, (Object)b.sw) && Objects.equals((Object)this.ne, (Object)b.ne);
        }
        return false;
    }

    public String toString() {
        return "(" + (Object)((Object)this.ne) + ", " + (Object)((Object)this.sw) + ")";
    }
}

