/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.gmaps;

import org.fujion.ancillary.Options;
import org.fujion.annotation.Option;
import org.fujion.common.StrUtil;

public class LatLng
extends Options {
    @Option
    protected double lat;
    @Option
    protected double lng;
    @Option
    public Boolean noWrap;

    public static LatLng parse(String value) {
        if (value == null) {
            return null;
        }
        String[] pcs = (value = StrUtil.xlate((String)value, (String)"+[]()\u00b0 ", (String)"").toUpperCase()).split("\\,");
        if (pcs.length != 2) {
            return null;
        }
        return new LatLng(LatLng.parse(pcs[0], "NS"), LatLng.parse(pcs[1], "EW"));
    }

    private static double parse(String value, String dir) {
        int i;
        int n = i = value.isEmpty() ? -1 : dir.indexOf(value.charAt(value.length() - 1));
        if (i > -1) {
            value = value.substring(0, value.length() - 1);
        }
        double result = Double.parseDouble(value);
        return i == -1 ? result : (i == 1 ? -result : result);
    }

    public LatLng(double lat, double lng) {
        this(lat, lng, null);
    }

    public LatLng(double lat, double lng, Boolean noWrap) {
        this.lat = lat;
        this.lng = lng;
        this.noWrap = noWrap;
    }

    public double getLatitude() {
        return this.lat;
    }

    public double getLongitude() {
        return this.lng;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof LatLng) {
            LatLng p = (LatLng)((Object)o);
            return p.lat == this.lat && p.lng == this.lng;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        this.toString(sb, this.lat, "N", "S").append(", ");
        this.toString(sb, this.lng, "E", "W").append("]");
        return sb.toString();
    }

    private StringBuilder toString(StringBuilder sb, double value, String dir1, String dir2) {
        String dir = value >= 0.0 ? dir1 : dir2;
        sb.append(Math.abs(value)).append("\u00b0").append(dir);
        return sb;
    }
}

