/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.gmaps;

import org.fujion.ancillary.Options;
import org.fujion.annotation.Option;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class LoaderOptions
extends Options {
    public static final LoaderOptions instance = new LoaderOptions();
    @Option(value="KEY")
    @Value(value="${org.fujion.gmaps.key:}")
    private String apiKey;
    @Option(value="VERSION")
    @Value(value="${org.fujion.gmaps.version:3.31}")
    private String apiVersion;
    @Option(value="LIBRARIES", convertUsing="value.split('\\,')")
    @Value(value="${org.fujion.gmaps.libraries:#{null}}")
    private String libraries;
    @Option(value="CLIENT")
    @Value(value="${org.fujion.gmaps.client:#{null}}")
    private String client;
    @Option(value="CHANNEL")
    @Value(value="${org.fujion.gmaps.channel:#{null}}")
    private String channel;
    @Option(value="LANGUAGE")
    @Value(value="${org.fujion.gmaps.language:#{null}}")
    private String language;
    @Option(value="REGION")
    @Value(value="${org.fujion.gmaps.region:#{null}}")
    private String region;
    @Option(value="URL")
    @Value(value="${org.fujion.gmaps.url:#{null}}")
    private String url;

    public static LoaderOptions getInstance() {
        return instance;
    }

    private LoaderOptions() {
    }

    public LoaderOptions validate() {
        Assert.isTrue((!StringUtils.isEmpty((Object)this.apiKey) ? 1 : 0) != 0, () -> "An API key must be specified to access Google Maps functionality");
        return this;
    }
}

