/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.gmaps;

import org.fujion.ancillary.OptionMap;
import org.springframework.util.Assert;

public class Styler<T>
implements OptionMap.IOptionMapConverter {
    private final OptionMap map = new OptionMap();

    private Styler(String type, T value) {
        this.map.put(type, value);
    }

    public OptionMap toMap() {
        return this.map;
    }

    public static class WeightStyler
    extends Styler<Integer> {
        public WeightStyler(int weight) {
            super("weight", weight);
            Assert.isTrue((weight >= 0 ? 1 : 0) != 0, () -> "Weight must be greater than or equal to 0");
        }
    }

    public static class VisibilityStyler
    extends Styler<VisibilityType> {
        public VisibilityStyler(VisibilityType visibility) {
            super("visibility", (Object)visibility);
        }
    }

    public static enum VisibilityType {
        ON,
        OFF,
        SIMPLIFIED;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static class InvertLightnessStyler
    extends Styler<Boolean> {
        public InvertLightnessStyler() {
            super("invert_lightness", true);
        }
    }

    public static class GammaStyler
    extends Styler<Double> {
        public GammaStyler(double gamma) {
            super("gamma", gamma);
            Assert.isTrue((gamma >= 0.01 && gamma <= 10.0 ? 1 : 0) != 0, () -> "Gamma must be between 0.01 and 10.0, inclusive");
        }
    }

    public static class SaturationStyler
    extends Styler<Double> {
        public SaturationStyler(double saturation) {
            super("saturation", saturation);
            Assert.isTrue((saturation >= -100.0 && saturation <= 100.0 ? 1 : 0) != 0, () -> "Saturation must be between -100 and 100, inclusive");
        }
    }

    public static class LightnessStyler
    extends Styler<Double> {
        public LightnessStyler(double lightness) {
            super("lightness", lightness);
            Assert.isTrue((lightness >= -100.0 && lightness <= 100.0 ? 1 : 0) != 0, () -> "Lightness must be between -100 and 100, inclusive");
        }
    }

    public static class ColorStyler
    extends Styler<String> {
        public ColorStyler(String color) {
            super("color", color);
        }
    }

    public static class HueStyler
    extends Styler<String> {
        public HueStyler(String color) {
            super("hue", color);
        }
    }
}

