/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.highcharts;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.fujion.ancillary.ConvertUtil;
import org.fujion.ancillary.OptionMap;
import org.fujion.ancillary.Options;
import org.fujion.annotation.Component;
import org.fujion.component.BaseUIComponent;
import org.fujion.component.Page;
import org.fujion.highcharts.Axis;
import org.fujion.highcharts.ChartOptions;
import org.fujion.highcharts.CreditsOptions;
import org.fujion.highcharts.ExportingOptions;
import org.fujion.highcharts.GlobalSettings;
import org.fujion.highcharts.LegendOptions;
import org.fujion.highcharts.LoadingOptions;
import org.fujion.highcharts.NavigationOptions;
import org.fujion.highcharts.PaneOptions;
import org.fujion.highcharts.PlotOptions;
import org.fujion.highcharts.Series;
import org.fujion.highcharts.TitleOptions;
import org.fujion.highcharts.TooltipOptions;
import org.fujion.highcharts.Util;

@Component(tag="hchart", widgetModule="fujion-hchart", widgetClass="HChart", parentTag={"*"})
public class Chart
extends BaseUIComponent
implements OptionMap.IOptionMapConverter {
    private static final String GLOBAL_SETTINGS = Chart.class.getName() + ".global";
    public final ChartSettings options = new ChartSettings();
    private boolean running;

    public Chart() {
        this.addXAxis();
        this.addYAxis();
        this.setType("line");
    }

    public void setDefaultColors(String ... colors) {
        this.options.colors.clear();
        if (colors != null) {
            this.options.colors.addAll(Arrays.asList(colors));
        }
    }

    @Component.PropertyGetter(value="type")
    public String getType() {
        return this.options.chart.type;
    }

    @Component.PropertySetter(value="type")
    public void setType(String type) {
        try {
            Field field = ChartSettings.class.getField("plotOptions");
            field.setAccessible(true);
            PlotOptions plotOptions = Util.getPlotType(type);
            plotOptions.type = type;
            field.set((Object)this.options, (Object)plotOptions);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.options.chart.type = type;
        this.options.series.clear();
    }

    public Axis getXAxis() {
        return this.options.xAxis.isEmpty() ? null : this.options.xAxis.get(0);
    }

    public Axis getYAxis() {
        return this.options.yAxis.isEmpty() ? null : this.options.yAxis.get(0);
    }

    public Series addSeries() {
        return this.addSeries(this.options.chart.type);
    }

    public Series addSeries(String type) {
        Series series = new Series(type);
        this.options.series.add(series);
        return series;
    }

    public Axis addXAxis() {
        return new Axis(this.options.xAxis);
    }

    public Axis addYAxis() {
        return new Axis(this.options.yAxis);
    }

    public void run() {
        this.init();
        this.invoke("_run", new Object[]{this.toMap()});
        this.running = true;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void clear() {
        this.running = false;
        this.options.series.clear();
        this.invoke("_reset", new Object[0]);
    }

    public void redraw() {
        if (this.running) {
            this.invoke("_redraw", new Object[0]);
        } else {
            this.run();
        }
    }

    private void init() {
        if (this.shouldInitialize()) {
            this.invoke("_global", new Object[]{new GlobalSettings().toMap()});
        }
    }

    private boolean shouldInitialize() {
        Page pg = this.getPage();
        if (pg != null && !pg.hasAttribute(GLOBAL_SETTINGS)) {
            pg.setAttribute(GLOBAL_SETTINGS, (Object)true);
            return true;
        }
        return false;
    }

    public OptionMap toMap() {
        this.options.chart.renderTo = this.getId();
        return this.options.toMap();
    }

    @Component.PropertyGetter(value="title")
    public String getTitle() {
        return this.options.title.text;
    }

    @Component.PropertySetter(value="title")
    public void setTitle(String text) {
        this.options.title.text = text;
        this.updateTitle();
    }

    @Component.PropertyGetter(value="subtitle")
    public String getSubtitle() {
        return this.options.subtitle.text;
    }

    @Component.PropertySetter(value="subtitle")
    public void setSubtitle(String text) {
        this.options.subtitle.text = text;
        this.updateTitle();
    }

    public void export() {
        this.ensureRunning("Exporting");
        this.invokeJS("_export", this.options.exporting.buttons_exportButton.onclick);
    }

    public void print() {
        this.ensureRunning("Printing");
        this.invokeJS("_print", this.options.exporting.buttons_printButton.onclick);
    }

    private void invokeJS(String func, String js) {
        this.invoke(func, new Object[]{ConvertUtil.convertToJS((String)js)});
    }

    private void updateTitle() {
        if (this.running) {
            OptionMap map = new OptionMap();
            map.put("title", (Object)this.options.title);
            map.put("subtitle", (Object)this.options.subtitle);
            this.invoke("_title", new Object[]{map});
        }
    }

    private void ensureRunning(String operation) {
        if (!this.running) {
            throw new RuntimeException(operation + " requires an active chart.");
        }
    }

    public static class ChartSettings
    extends Options {
        public final ChartOptions chart = new ChartOptions();
        public final List<String> colors = new ArrayList<String>();
        public final CreditsOptions credits = new CreditsOptions();
        public final ExportingOptions exporting = new ExportingOptions();
        public final LegendOptions legend = new LegendOptions();
        public final LoadingOptions loading = new LoadingOptions();
        public final NavigationOptions navigation = new NavigationOptions();
        public final PaneOptions pane = new PaneOptions();
        public final PlotOptions plotOptions = null;
        public final List<Series> series = new ArrayList<Series>();
        public final TitleOptions subtitle = new TitleOptions();
        public final TitleOptions title = new TitleOptions();
        public final TooltipOptions tooltip = new TooltipOptions();
        public final List<Axis> xAxis = new ArrayList<Axis>();
        public final List<Axis> yAxis = new ArrayList<Axis>();
    }
}

