/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.highcharts;

import java.lang.reflect.Field;
import org.fujion.ancillary.Options;
import org.fujion.common.StrUtil;
import org.fujion.highcharts.GlobalOptions;
import org.fujion.highcharts.LanguageOptions;

public class GlobalSettings
extends Options {
    private static final String LABEL_PREFIX = "highcharts.";
    public final GlobalOptions global = new GlobalOptions();
    public final LanguageOptions lang = new LanguageOptions();

    protected GlobalSettings() {
        this.loadSettings("global.", this.global);
        this.loadSettings("lang.", this.lang);
    }

    private void loadSettings(String cat, Options options) {
        for (Field field : options.getClass().getFields()) {
            try {
                String value = StrUtil.getLabel((String)(LABEL_PREFIX + cat + field.getName()), (Object[])new Object[0]);
                if (value == null || value.isEmpty()) continue;
                Class<?> type = field.getType();
                if (type.isArray()) {
                    field.set(options, value.split("\\,"));
                    continue;
                }
                if (type == Boolean.class) {
                    field.set(options, Boolean.valueOf(value));
                    continue;
                }
                field.set(options, value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

