/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.highcharts;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.fujion.ancillary.OptionMap;
import org.fujion.ancillary.Options;
import org.fujion.highcharts.DataPoint;
import org.fujion.highcharts.PlotOptions;
import org.fujion.highcharts.Util;

public class Series
extends Options {
    public final List<DataPoint> data = new ArrayList<DataPoint>();
    public Integer index;
    public Integer legendIndex;
    public String name;
    public Object stack;
    public final String type;
    public Integer xAxis;
    public Integer yAxis;
    public final transient PlotOptions plotOptions;

    protected Series(String type) {
        this.type = type;
        this.plotOptions = Util.getPlotType(type);
    }

    public DataPoint addDataPoint(double y) {
        DataPoint dp = new DataPoint();
        dp.y = y;
        this.data.add(dp);
        return dp;
    }

    public DataPoint addDataPoint(double x, double y) {
        DataPoint dp = this.addDataPoint(y);
        dp.x = x;
        return dp;
    }

    public void addDataPoints(List<DataPoint> values) {
        this.data.addAll(values);
    }

    public void addDataPoints(double ... yvalues) {
        for (double y : yvalues) {
            this.addDataPoint(y);
        }
    }

    public void clear() {
        this.data.clear();
    }

    public OptionMap toMap() {
        OptionMap map = super.toMap();
        map.putAll((Map)this.plotOptions.toMap());
        return map;
    }
}

