/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.highcharts;

import java.util.HashMap;
import java.util.Map;
import org.fujion.annotation.ComponentScanner;
import org.fujion.highcharts.PlotArea;
import org.fujion.highcharts.PlotAreaRange;
import org.fujion.highcharts.PlotAreaSpline;
import org.fujion.highcharts.PlotAreaSplineRange;
import org.fujion.highcharts.PlotBar;
import org.fujion.highcharts.PlotBox;
import org.fujion.highcharts.PlotBubble;
import org.fujion.highcharts.PlotColumn;
import org.fujion.highcharts.PlotColumnRange;
import org.fujion.highcharts.PlotErrorBar;
import org.fujion.highcharts.PlotFunnel;
import org.fujion.highcharts.PlotGauge;
import org.fujion.highcharts.PlotLine;
import org.fujion.highcharts.PlotOptions;
import org.fujion.highcharts.PlotPie;
import org.fujion.highcharts.PlotScatter;
import org.fujion.highcharts.PlotSolidGauge;
import org.fujion.highcharts.PlotSpline;
import org.fujion.highcharts.PlotWaterfall;

public class Util {
    private static final Map<String, Class<? extends PlotOptions>> plotTypes = new HashMap<String, Class<? extends PlotOptions>>();

    public static PlotOptions getPlotType(String type) {
        try {
            return plotTypes.get(type).newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid plot type: " + type);
        }
    }

    public static void init() {
        ComponentScanner.getInstance().scanPackage(Util.class.getPackage());
        plotTypes.put("area", PlotArea.class);
        plotTypes.put("arearange", PlotAreaRange.class);
        plotTypes.put("areaspline", PlotAreaSpline.class);
        plotTypes.put("areasplinerange", PlotAreaSplineRange.class);
        plotTypes.put("bar", PlotBar.class);
        plotTypes.put("boxplot", PlotBox.class);
        plotTypes.put("bubble", PlotBubble.class);
        plotTypes.put("column", PlotColumn.class);
        plotTypes.put("columnrange", PlotColumnRange.class);
        plotTypes.put("errorbar", PlotErrorBar.class);
        plotTypes.put("funnel", PlotFunnel.class);
        plotTypes.put("gauge", PlotGauge.class);
        plotTypes.put("line", PlotLine.class);
        plotTypes.put("pie", PlotPie.class);
        plotTypes.put("scatter", PlotScatter.class);
        plotTypes.put("solidgauge", PlotSolidGauge.class);
        plotTypes.put("spline", PlotSpline.class);
        plotTypes.put("waterfall", PlotWaterfall.class);
    }

    private Util() {
    }
}

