/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.highcharts;

import org.fujion.common.MiscUtil;
import org.fujion.highcharts.PlotArea;
import org.fujion.highcharts.PlotAreaRange;
import org.fujion.highcharts.PlotAreaSpline;
import org.fujion.highcharts.PlotAreaSplineRange;
import org.fujion.highcharts.PlotBar;
import org.fujion.highcharts.PlotBellCurve;
import org.fujion.highcharts.PlotBox;
import org.fujion.highcharts.PlotBubble;
import org.fujion.highcharts.PlotBullet;
import org.fujion.highcharts.PlotColumn;
import org.fujion.highcharts.PlotColumnRange;
import org.fujion.highcharts.PlotErrorBar;
import org.fujion.highcharts.PlotFunnel;
import org.fujion.highcharts.PlotGauge;
import org.fujion.highcharts.PlotHeatMap;
import org.fujion.highcharts.PlotHistogram;
import org.fujion.highcharts.PlotLine;
import org.fujion.highcharts.PlotOptions;
import org.fujion.highcharts.PlotPareto;
import org.fujion.highcharts.PlotPie;
import org.fujion.highcharts.PlotPolygon;
import org.fujion.highcharts.PlotPyramid;
import org.fujion.highcharts.PlotSankey;
import org.fujion.highcharts.PlotScatter;
import org.fujion.highcharts.PlotScatter3D;
import org.fujion.highcharts.PlotSolidGauge;
import org.fujion.highcharts.PlotSpline;
import org.fujion.highcharts.PlotStreamGraph;
import org.fujion.highcharts.PlotSunburst;
import org.fujion.highcharts.PlotTileMap;
import org.fujion.highcharts.PlotTreeMap;
import org.fujion.highcharts.PlotVariablePie;
import org.fujion.highcharts.PlotVariwide;
import org.fujion.highcharts.PlotVector;
import org.fujion.highcharts.PlotWaterfall;
import org.fujion.highcharts.PlotWindbarb;
import org.fujion.highcharts.PlotWordCloud;
import org.fujion.highcharts.PlotXRange;

public enum PlotType {
    AREA(PlotArea.class),
    AREARANGE(PlotAreaRange.class),
    AREASPLINE(PlotAreaSpline.class),
    AREASPLINERANGE(PlotAreaSplineRange.class),
    BAR(PlotBar.class),
    BELLCURVE(PlotBellCurve.class),
    BOXPLOT(PlotBox.class),
    BUBBLE(PlotBubble.class),
    BULLET(PlotBullet.class),
    COLUMN(PlotColumn.class),
    COLUMNRANGE(PlotColumnRange.class),
    ERRORBAR(PlotErrorBar.class),
    FUNNEL(PlotFunnel.class),
    GAUGE(PlotGauge.class),
    HEATMAP(PlotHeatMap.class),
    HISTOGRAM(PlotHistogram.class),
    LINE(PlotLine.class),
    PARETO(PlotPareto.class),
    PIE(PlotPie.class),
    POLYGON(PlotPolygon.class),
    PYRAMID(PlotPyramid.class),
    SANKEY(PlotSankey.class),
    SCATTER(PlotScatter.class),
    SCATTER3D(PlotScatter3D.class),
    SOLIDGAUGE(PlotSolidGauge.class),
    SPLINE(PlotSpline.class),
    STREAMGRAPH(PlotStreamGraph.class),
    SUNBURST(PlotSunburst.class),
    TILEMAP(PlotTileMap.class),
    TREEMAP(PlotTreeMap.class),
    VARIABLEPIE(PlotVariablePie.class),
    VARIWIDE(PlotVariwide.class),
    VECTOR(PlotVector.class),
    WATERFALL(PlotWaterfall.class),
    WINDBARB(PlotWindbarb.class),
    WORDCLOUD(PlotWordCloud.class),
    XRANGE(PlotXRange.class);

    private final Class<? extends PlotOptions> optionClass;

    public static PlotType fromPlotClass(Class<? extends PlotOptions> optionClass) {
        for (PlotType type : PlotType.values()) {
            if (type.optionClass != optionClass) continue;
            return type;
        }
        return null;
    }

    private PlotType(Class<? extends PlotOptions> optionClass) {
        this.optionClass = optionClass;
    }

    public PlotOptions newInstance() {
        try {
            PlotOptions plotOptions = this.optionClass.newInstance();
            plotOptions.type = this.toString();
            return plotOptions;
        }
        catch (Exception e) {
            throw MiscUtil.toUnchecked((Throwable)e);
        }
    }

    public String toString() {
        return this.name().toLowerCase();
    }
}

