/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.highcharts;

import java.util.Arrays;
import org.fujion.ancillary.ConvertUtil;
import org.fujion.ancillary.JavaScript;
import org.fujion.ancillary.OptionMap;
import org.fujion.annotation.Component;
import org.fujion.component.BaseUIComponent;
import org.fujion.component.Page;
import org.fujion.highcharts.Axis;
import org.fujion.highcharts.ChartInstance;
import org.fujion.highcharts.GlobalSettings;
import org.fujion.highcharts.PlotType;
import org.fujion.highcharts.Series;
import org.springframework.util.Assert;

@Component(tag="hchart", widgetModule="fujion-hchart", widgetClass="HChart", parentTag={"*"}, description="Fujion wrapper for HighCharts component.")
public class Chart
extends BaseUIComponent {
    private static final String GLOBAL_SETTINGS = Chart.class.getName() + ".global";
    public final ChartInstance instance = new ChartInstance();
    private boolean running;

    public Chart() {
        this.addXAxis();
        this.addYAxis();
        this.setType(PlotType.LINE);
    }

    public void setDefaultColors(String ... colors) {
        this.instance.getColors().clear();
        if (colors != null) {
            this.instance.getColors().addAll(Arrays.asList(colors));
        }
    }

    @Component.PropertyGetter(value="type", description="The chart type.")
    public PlotType getType() {
        return this.instance.getChart().type;
    }

    @Component.PropertySetter(value="type", defaultValue="line", description="The chart type.")
    public void setType(PlotType type) {
        type = type == null ? PlotType.LINE : type;
        this.instance.setPlotOptions(type.newInstance());
        this.instance.getChart().type = type;
        this.instance.getSeries().clear();
    }

    public Axis getXAxis() {
        return this.instance.getxAxis().isEmpty() ? null : this.instance.getxAxis().get(0);
    }

    public Axis getYAxis() {
        return this.instance.getyAxis().isEmpty() ? null : this.instance.getyAxis().get(0);
    }

    public Series addSeries() {
        return this.addSeries(this.instance.getChart().type);
    }

    public Series addSeries(PlotType type) {
        Series series = new Series(type);
        this.instance.getSeries().add(series);
        return series;
    }

    public Axis addXAxis() {
        return new Axis(this.instance.getxAxis());
    }

    public Axis addYAxis() {
        return new Axis(this.instance.getyAxis());
    }

    public void run() {
        this.init();
        this.invoke("_run", new Object[]{this.instance});
        this.running = true;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void clear() {
        this.running = false;
        this.instance.getSeries().clear();
        this.invoke("_reset", new Object[0]);
    }

    public void redraw() {
        if (this.running) {
            this.invoke("_redraw", new Object[0]);
        } else {
            this.run();
        }
    }

    private void init() {
        if (this.shouldInitialize()) {
            this.invoke("_global", new Object[]{new GlobalSettings()});
        }
    }

    private boolean shouldInitialize() {
        Page pg = this.getPage();
        if (pg != null && !pg.hasAttribute((Object)GLOBAL_SETTINGS)) {
            pg.setAttribute((Object)GLOBAL_SETTINGS, (Object)true);
            return true;
        }
        return false;
    }

    @Component.PropertyGetter(value="title", description="The title text.")
    public String getTitle() {
        return this.instance.getTitle().text;
    }

    @Component.PropertySetter(value="title", description="The title text.")
    public void setTitle(String text) {
        this.instance.getTitle().text = text;
        this.updateTitle();
    }

    @Component.PropertyGetter(value="subtitle", description="The subtitle text.")
    public String getSubtitle() {
        return this.instance.getSubtitle().text;
    }

    @Component.PropertySetter(value="subtitle", description="The subtitle text.")
    public void setSubtitle(String text) {
        this.instance.getSubtitle().text = text;
        this.updateTitle();
    }

    public void export() {
        this.ensureRunning("Exporting");
        this.invokeJS("_export", this.instance.getExporting().buttons_exportButton.onclick);
    }

    public void print() {
        this.ensureRunning("Printing");
        this.invokeJS("_print", this.instance.getExporting().buttons_printButton.onclick);
    }

    private void invokeJS(String func, String js) {
        this.invoke(func, new Object[]{ConvertUtil.convert((Object)js, JavaScript.class)});
    }

    private void updateTitle() {
        if (this.running) {
            OptionMap map = new OptionMap();
            map.put("title", (Object)this.instance.getTitle());
            map.put("subtitle", (Object)this.instance.getSubtitle());
            this.invoke("_title", new Object[]{map});
        }
    }

    private void ensureRunning(String operation) {
        Assert.state((boolean)this.running, () -> operation + " requires an active chart.");
    }
}

