/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.icon;

import java.util.List;
import org.fujion.icon.IIconLibrary;
import org.fujion.icon.IconLibraryRegistry;
import org.springframework.util.AntPathMatcher;

public class IconUtil {
    protected static final AntPathMatcher matcher = new AntPathMatcher();

    public static String getIconPath(String icon) {
        return IconUtil.getIconPath(null, icon, null);
    }

    public static String getIconPath(String library, String icon, String dimensions) {
        IconParams params = new IconParams(icon, dimensions, library);
        IIconLibrary lib = IconLibraryRegistry.getInstance().get(params.library);
        return lib == null ? null : lib.getIconPath(params.name, params.dimensions);
    }

    public static List<String> getMatching(String library, String icon, String dimensions) {
        return IconLibraryRegistry.getInstance().getMatching(library, icon, dimensions);
    }

    private IconUtil() {
    }

    private static class IconParams {
        final String name;
        final String dimensions;
        final String library;

        IconParams(String icon, String defltDimensions, String defltLibrary) {
            String[] pcs = icon.split("\\:", 3);
            boolean all = pcs.length > 1;
            this.library = this.getElement(pcs, all ? 0 : -1, defltLibrary);
            this.name = this.getElement(pcs, all ? 1 : 0, "noname");
            this.dimensions = this.getElement(pcs, all ? 2 : -1, defltDimensions);
        }

        private String getElement(String[] pcs, int index, String deflt) {
            String element = index >= 0 && index < pcs.length ? pcs[index] : "";
            return element.isEmpty() ? deflt : element;
        }
    }
}

