/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.icon;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.fujion.common.Logger;
import org.fujion.icon.IIconLibrary;
import org.fujion.icon.IconUtil;
import org.fujion.webjar.WebJar;
import org.fujion.webjar.WebJarLocator;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.Assert;

public abstract class IconLibraryBase
implements IIconLibrary,
ApplicationContextAware {
    private static final Logger log = Logger.create(IconLibraryBase.class);
    private final String defaultExtension;
    private final WebJar webjar;
    private final String[] dimensions;
    private ResourcePatternResolver resolver;

    protected IconLibraryBase(String webjarName, String defaultExtension, String ... dimensions) {
        this.webjar = WebJarLocator.getInstance().getWebJar(webjarName);
        Assert.notNull((Object)this.webjar, () -> "Cannot find webjar named \"" + webjarName + "\" during icon library initialization");
        this.dimensions = dimensions;
        this.defaultExtension = defaultExtension.startsWith(".") ? defaultExtension : "." + defaultExtension;
    }

    @Override
    public String getId() {
        return this.webjar.getName();
    }

    @Override
    public String getIconPath(String iconName, String dimensions) {
        return this.webjar.getRootPath() + this.webjar.getVersion() + "/" + this.formatPath(iconName, dimensions);
    }

    @Override
    public List<String> getMatching(String iconName, String dims) {
        ArrayList<String> matches = new ArrayList<String>();
        try {
            for (String dim : this.resolveDims(dims)) {
                String path = this.webjar.getAbsolutePath() + "**/" + this.formatPath(iconName, dim);
                for (Resource resource : this.resolver.getResources(path)) {
                    if (!resource.exists()) continue;
                    String p = resource.getURL().getPath();
                    int i = p.lastIndexOf("jar!/META-INF/resources/webjars/");
                    matches.add(p.substring(i + 24));
                }
            }
        }
        catch (IOException e) {
            log.error((Object)"Error enumerating icons.", (Throwable)e);
        }
        return matches;
    }

    @Override
    public String[] supportedDimensions() {
        return this.dimensions;
    }

    protected String getDefaultExtension() {
        return this.defaultExtension;
    }

    protected String getDefaultDimension() {
        return ArrayUtils.isEmpty((Object[])this.dimensions) ? "" : this.dimensions[0];
    }

    protected List<String> resolveDims(String dims) {
        String string = dims = StringUtils.isEmpty((CharSequence)dims) ? this.getDefaultDimension() : dims.toLowerCase();
        if (ArrayUtils.contains((Object[])this.dimensions, (Object)dims)) {
            return Collections.singletonList(dims);
        }
        if (!dims.contains("x")) {
            dims = dims + "x" + dims;
        }
        ArrayList<String> results = new ArrayList<String>();
        if (!ArrayUtils.isEmpty((Object[])this.dimensions)) {
            for (String dim : this.dimensions) {
                if (!IconUtil.matcher.match(dims, dim)) continue;
                results.add(dim);
            }
        }
        return results;
    }

    protected String expandName(String name) {
        return name.contains(".") ? name : name + this.defaultExtension;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.resolver = applicationContext;
    }

    private String formatPath(String iconName, String dimensions) {
        return this.doFormatPath(iconName, StringUtils.isEmpty((CharSequence)dimensions) ? this.getDefaultDimension() : dimensions);
    }

    protected abstract String doFormatPath(String var1, String var2);
}

