/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.icon;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.fujion.common.AbstractRegistry;
import org.fujion.common.Logger;
import org.fujion.icon.IIconLibrary;
import org.fujion.icon.IconUtil;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class IconLibraryRegistry
extends AbstractRegistry<String, IIconLibrary>
implements BeanPostProcessor {
    private static final Logger log = Logger.create(IconLibraryRegistry.class);
    private static final IconLibraryRegistry instance = new IconLibraryRegistry();
    private String defaultLibrary;
    private String defaultDimensions;

    public static IconLibraryRegistry init(String defaultLibrary, String defaultDimensions) {
        IconLibraryRegistry.instance.defaultLibrary = StringUtils.trimToNull((String)defaultLibrary);
        IconLibraryRegistry.instance.defaultDimensions = StringUtils.trimToNull((String)defaultDimensions);
        return instance;
    }

    public static IconLibraryRegistry getInstance() {
        return instance;
    }

    private IconLibraryRegistry() {
    }

    public void register(IIconLibrary library) {
        super.register((Object)library);
        if (this.defaultLibrary == null) {
            this.defaultLibrary = library.getId();
        }
    }

    public IIconLibrary get(String library) {
        return (IIconLibrary)super.get((Object)(library == null ? this.defaultLibrary : library));
    }

    protected String getKey(IIconLibrary item) {
        return item.getId();
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof IIconLibrary) {
            IIconLibrary lib = (IIconLibrary)bean;
            this.register(lib);
            log.info(() -> "Registered icon library: " + lib.getId());
        }
        return bean;
    }

    public String getDefaultLibrary() {
        return this.defaultLibrary;
    }

    public List<String> getMatching(String library, String iconName, String dimensions) {
        dimensions = dimensions == null ? this.defaultDimensions : dimensions;
        List<String> results = null;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            IIconLibrary lib = (IIconLibrary)iterator.next();
            if (library != null && !IconUtil.matcher.match(library, lib.getId())) continue;
            List<String> urls = lib.getMatching(iconName, dimensions);
            if (results == null) {
                results = urls;
                continue;
            }
            results.addAll(urls);
        }
        return results == null ? Collections.emptyList() : results;
    }
}

