/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.multimedia;

import org.fujion.annotation.Component;
import org.fujion.common.Assert;
import org.fujion.component.BaseUIComponent;

public abstract class BaseMultimediaComponent
extends BaseUIComponent {
    private String src;
    private boolean muted;
    private boolean controls;
    private boolean loop;
    private double volume = 0.5;
    private double rate = 1.0;

    public void fade(double from, double to, int duration) {
        this._validateVolume(from, "From");
        this._validateVolume(to, "To");
        this.invoke("fade", new Object[]{from, to, duration});
    }

    public void play() {
        this.invoke("play", new Object[0]);
    }

    public void pause() {
        this.invoke("pause", new Object[0]);
    }

    public void seek(int position) {
        this.invoke("seek", new Object[]{position});
    }

    public void stop() {
        this.invoke("stop", new Object[0]);
    }

    @Component.PropertyGetter(value="src", description="The URL of the external audio source.")
    public String getSrc() {
        return this.src;
    }

    @Component.PropertySetter(value="src", description="The URL of the external audio source.")
    public void setSrc(String src) {
        this.src = this.nullify(src);
        this.propertyChange("src", this.src, this.src, true);
    }

    @Component.PropertyGetter(value="muted", description="True to mute the audio track.")
    public boolean getMuted() {
        return this.muted;
    }

    @Component.PropertySetter(value="muted", defaultValue="false", description="True to mute the audio track.")
    public void setMuted(boolean muted) {
        this.muted = muted;
        this.propertyChange("muted", this.muted, this.muted, true);
    }

    @Component.PropertyGetter(value="volume", description="The volume (0 - 1) of the audio source.")
    public double getVolume() {
        return this.volume;
    }

    @Component.PropertySetter(value="volume", defaultValue="50", description="The volume (0 - 1) of the audio source.")
    public void setVolume(double volume) {
        this._validateVolume(volume, "Volume");
        this.volume = volume;
        this.propertyChange("volume", this.volume, this.volume, true);
    }

    @Component.PropertyGetter(value="loop", description="True to loop the audio track.")
    public boolean getLoop() {
        return this.loop;
    }

    @Component.PropertySetter(value="loop", defaultValue="false", description="True to loop the audio track.")
    public void setLoop(boolean loop) {
        this.loop = loop;
        this.propertyChange("loop", this.loop, this.loop, true);
    }

    @Component.PropertyGetter(value="rate", description="The playback speed (0.5 - 4.0).")
    public double getRate() {
        return this.rate;
    }

    @Component.PropertySetter(value="rate", defaultValue="1.0", description="The playback speed (0.5 - 4.0).")
    public void setRate(double rate) {
        Assert.isTrue((rate >= 0.5 && rate <= 4.0 ? 1 : 0) != 0, (String)"Rate must be between 0.5 and 4.0, inclusive", (Object[])new Object[0]);
        this.rate = rate;
        this.propertyChange("rate", this.rate, this.rate, true);
    }

    @Component.PropertyGetter(value="controls", description="If true, show multimedia controls.")
    public boolean getControls() {
        return this.controls;
    }

    @Component.PropertySetter(value="controls", defaultValue="false", description="If true, show multimedia controls.")
    public void setControls(boolean controls) {
        this.controls = controls;
        this.propertyChange("controls", this.controls, this.controls, true);
    }

    private void _validateVolume(double value, String propName) {
        Assert.isTrue((value >= 0.0 && value <= 1.0 ? 1 : 0) != 0, (String)"%s must be between 0 and 1, inclusive", (Object[])new Object[]{propName});
    }
}

