/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.sandbox;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.fujion.ancillary.IAutoWired;
import org.fujion.annotation.EventHandler;
import org.fujion.annotation.WiredComponent;
import org.fujion.codemirror.CodeMirror;
import org.fujion.common.MiscUtil;
import org.fujion.component.BaseComponent;
import org.fujion.component.Combobox;
import org.fujion.component.Comboitem;
import org.fujion.component.Label;
import org.fujion.component.Namespace;
import org.fujion.component.Window;
import org.fujion.event.EventUtil;
import org.fujion.model.IComponentRenderer;
import org.fujion.model.ListModel;
import org.fujion.page.PageUtil;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;

public class MainController
implements IAutoWired,
ApplicationContextAware {
    private static final Window.Mode[] REPLACE_MODES = new Window.Mode[]{Window.Mode.MODAL, Window.Mode.POPUP};
    private static final Comparator<Resource> resourceComparator = (r1, r2) -> r1.getFilename().compareToIgnoreCase(r2.getFilename());
    private static final IComponentRenderer<Comboitem, Resource> fujionRenderer = new IComponentRenderer<Comboitem, Resource>(){

        public Comboitem render(Resource resource) {
            Comboitem item = new Comboitem();
            item.setData((Object)resource);
            item.setLabel(resource.getFilename());
            item.setHint(this.getPath(resource));
            return item;
        }

        private String getPath(Resource resource) {
            try {
                String[] pcs = resource.getURL().toString().split("!", 2);
                if (pcs.length == 1) {
                    return pcs[0];
                }
                int i = pcs[0].lastIndexOf(47) + 1;
                return pcs[0].substring(i) + ":\n\n" + pcs[1];
            }
            catch (Exception e) {
                throw MiscUtil.toUnchecked((Throwable)e);
            }
        }
    };
    @WiredComponent
    private CodeMirror editor;
    @WiredComponent
    private Combobox cboFujion;
    @WiredComponent
    private BaseComponent contentParent;
    private Namespace contentBase;
    private BaseComponent root;
    private String content;
    private final ListModel<Resource> model = new ListModel();

    public void afterInitialized(BaseComponent comp) {
        this.root = comp;
        this.cboFujion.setRenderer(fujionRenderer);
        this.cboFujion.setModel(this.model);
        this.cboFujion.setVisible(this.model.size() > 0);
        this.contentBase = (Namespace)this.contentParent.getChild(Namespace.class);
    }

    @EventHandler(value={"refresh"})
    public void refresh() {
        this.contentBase.destroyChildren();
        if (this.content != null && !this.content.isEmpty()) {
            try {
                EventUtil.post((String)"modeCheck", (BaseComponent)this.root, null);
                PageUtil.createPageFromContent((String)this.content, (BaseComponent)this.contentBase);
            }
            catch (Exception e) {
                this.contentBase.destroyChildren();
                Label label = new Label(ExceptionUtils.getStackTrace((Throwable)e));
                this.contentBase.addChild((BaseComponent)label);
            }
        }
    }

    @EventHandler(value={"activate"})
    public void focus() {
        this.editor.focus();
    }

    @EventHandler(value={"modeCheck"}, target={"^"})
    private void onModeCheck() {
        this.modeCheck((BaseComponent)this.contentBase);
    }

    private void modeCheck(BaseComponent comp) {
        Window win;
        if (comp instanceof Window && (win = (Window)comp).isVisible() && ArrayUtils.contains((Object[])REPLACE_MODES, (Object)win.getMode())) {
            win.setMode(Window.Mode.INLINE);
        }
        for (BaseComponent child : comp.getChildren()) {
            this.modeCheck(child);
        }
    }

    @EventHandler(value={"click"}, target={"btnRenderContent"})
    private void onClick$btnRenderContent() {
        this.content = (String)this.editor.getValue();
        this.refresh();
        this.focus();
    }

    @EventHandler(value={"click"}, target={"btnClearContent"})
    private void onClick$btnClearContent() {
        this.editor.clear();
        this.cboFujion.setSelectedItem(null);
        this.cboFujion.setHint(null);
    }

    @EventHandler(value={"click"}, target={"btnClearView"})
    private void onClick$btnClearView() {
        this.contentBase.destroyChildren();
        this.focus();
    }

    @EventHandler(value={"click"}, target={"btnRefreshView"})
    private void onClick$btnRefreshView() {
        this.refresh();
    }

    @EventHandler(value={"click"}, target={"btnFormatContent"})
    private void onClick$btnFormatContent() {
        this.editor.format();
    }

    @EventHandler(value={"change"}, target={"@cboFujion"})
    private void onChange$cboFujion() throws IOException {
        Resource resource;
        Comboitem item = this.cboFujion.getSelectedItem();
        this.cboFujion.setHint(null);
        Resource resource2 = resource = item == null ? null : (Resource)item.getData(Resource.class);
        if (resource != null) {
            try (InputStream is = resource.getInputStream();){
                this.content = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                this.cboFujion.setHint(item.getHint());
                this.editor.setValue((Object)this.content);
                this.focus();
            }
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.findResources(applicationContext, "classpath*:**/*.fsp");
        this.findResources(applicationContext, "**/*.fsp");
        this.model.sort(resourceComparator, true);
    }

    private void findResources(ApplicationContext applicationContext, String pattern) {
        try {
            for (Resource resource : applicationContext.getResources(pattern)) {
                this.model.add((Object)resource);
            }
        }
        catch (Exception e) {
            throw MiscUtil.toUnchecked((Throwable)e);
        }
    }
}

