/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.sandbox;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.fujion.ancillary.ComponentRegistry;
import org.fujion.ancillary.IAutoWired;
import org.fujion.annotation.ComponentDefinition;
import org.fujion.annotation.EventHandler;
import org.fujion.annotation.WiredComponent;
import org.fujion.codemirror.CodeMirrorXML;
import org.fujion.common.MiscUtil;
import org.fujion.component.BaseComponent;
import org.fujion.component.Combobox;
import org.fujion.component.Comboitem;
import org.fujion.component.Label;
import org.fujion.component.Namespace;
import org.fujion.component.Window;
import org.fujion.event.EventUtil;
import org.fujion.model.IComponentRenderer;
import org.fujion.model.ListModel;
import org.fujion.page.PageUtil;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;

public class MainController
implements IAutoWired,
ApplicationContextAware {
    private static final Window.Mode[] REPLACE_MODES = new Window.Mode[]{Window.Mode.MODAL, Window.Mode.POPUP};
    private static final Comparator<Resource> resourceComparator = (r1, r2) -> r1.getFilename().compareToIgnoreCase(r2.getFilename());
    private static final IComponentRenderer<Comboitem, Resource> fujionRenderer = new IComponentRenderer<Comboitem, Resource>(){

        public Comboitem render(Resource resource) {
            Comboitem item = new Comboitem();
            item.setData((Object)resource);
            item.setLabel(resource.getFilename());
            item.setHint(this.getPath(resource));
            return item;
        }

        private String getPath(Resource resource) {
            try {
                String[] pcs = resource.getURL().toString().split("!", 2);
                if (pcs.length == 1) {
                    return pcs[0];
                }
                int i = pcs[0].lastIndexOf(47) + 1;
                return pcs[0].substring(i) + ":\n\n" + pcs[1];
            }
            catch (Exception e) {
                throw MiscUtil.toUnchecked((Throwable)e);
            }
        }
    };
    private static final CodeMirrorXML.SchemaInfo schemaInfo = new CodeMirrorXML.SchemaInfo();
    @WiredComponent
    private CodeMirrorXML editor;
    @WiredComponent
    private Combobox cboFujion;
    @WiredComponent
    private BaseComponent contentParent;
    private Namespace contentBase;
    private BaseComponent root;
    private String content;
    private final ListModel<Resource> model = new ListModel();

    private static void addAttributes(Map<String, Method> methods, CodeMirrorXML.Tag tag) {
        for (Map.Entry<String, Method> entry : methods.entrySet()) {
            Method method = entry.getValue();
            int p = method == null ? -1 : method.getParameterCount();
            Class<?> type = p != 1 ? null : method.getParameterTypes()[0];
            String name = entry.getKey();
            if (type == null || name.startsWith("#")) continue;
            if (type == Boolean.TYPE || type == Boolean.class) {
                tag.addAttribute(name, new String[]{"true", "false"});
                continue;
            }
            if (type.isEnum()) {
                ?[] members = type.getEnumConstants();
                String[] values = new String[members.length];
                for (int i = 0; i < members.length; ++i) {
                    values[i] = members[i].toString().toLowerCase();
                }
                tag.addAttribute(name, values);
                continue;
            }
            tag.addAttribute(name, new String[0]);
        }
    }

    public void afterInitialized(BaseComponent comp) {
        this.root = comp;
        this.cboFujion.setRenderer(fujionRenderer);
        this.cboFujion.setModel(this.model);
        this.cboFujion.setVisible(this.model.size() > 0);
        this.contentBase = (Namespace)this.contentParent.getFirstChild(Namespace.class);
        this.editor.setSchemaInfo(schemaInfo);
    }

    @EventHandler(value={"refresh"})
    public void refresh() {
        this.contentBase.destroyChildren();
        if (this.content != null && !this.content.isEmpty()) {
            try {
                EventUtil.post((String)"modeCheck", (BaseComponent)this.root, null);
                PageUtil.createPageFromContent((String)this.content, (BaseComponent)this.contentBase);
            }
            catch (Exception e) {
                this.contentBase.destroyChildren();
                Label label = new Label(ExceptionUtils.getStackTrace((Throwable)e));
                this.contentBase.addChild((BaseComponent)label);
            }
        }
    }

    @EventHandler(value={"activate"})
    public void focus() {
        this.editor.focus();
    }

    @EventHandler(value={"modeCheck"}, target={"^"})
    private void onModeCheck() {
        this.modeCheck((BaseComponent)this.contentBase);
    }

    private void modeCheck(BaseComponent comp) {
        Window win;
        if (comp instanceof Window && (win = (Window)comp).isVisible() && ArrayUtils.contains((Object[])REPLACE_MODES, (Object)win.getMode())) {
            win.setMode(Window.Mode.INLINE);
        }
        for (BaseComponent child : comp.getChildren()) {
            this.modeCheck(child);
        }
    }

    @EventHandler(value={"click"}, target={"btnRenderContent"})
    private void onClick$btnRenderContent() {
        this.content = (String)this.editor.getValue();
        this.refresh();
        this.focus();
    }

    @EventHandler(value={"click"}, target={"btnClearContent"})
    private void onClick$btnClearContent() {
        this.editor.clear();
        this.cboFujion.setSelectedItem(null);
        this.cboFujion.setHint(null);
    }

    @EventHandler(value={"click"}, target={"btnClearView"})
    private void onClick$btnClearView() {
        this.contentBase.destroyChildren();
        this.focus();
    }

    @EventHandler(value={"click"}, target={"btnRefreshView"})
    private void onClick$btnRefreshView() {
        this.refresh();
    }

    @EventHandler(value={"click"}, target={"btnFormatContent"})
    private void onClick$btnFormatContent() {
        this.editor.format();
    }

    @EventHandler(value={"change"}, target={"@cboFujion"})
    private void onChange$cboFujion() throws IOException {
        Resource resource;
        Comboitem item = this.cboFujion.getSelectedItem();
        this.cboFujion.setHint(null);
        Resource resource2 = resource = item == null ? null : (Resource)item.getData(Resource.class);
        if (resource != null) {
            try (InputStream is = resource.getInputStream();){
                this.content = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                this.cboFujion.setHint(item.getHint());
                this.editor.setValue((Object)this.content);
                this.focus();
            }
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.findResources(applicationContext, "classpath*:**/*.fsp");
        this.findResources(applicationContext, "**/*.fsp");
        this.model.sort(resourceComparator, true);
    }

    private void findResources(ApplicationContext applicationContext, String pattern) {
        try {
            this.model.addAll(Arrays.asList(applicationContext.getResources(pattern)));
        }
        catch (IOException e) {
            throw MiscUtil.toUnchecked((Throwable)e);
        }
    }

    static {
        CodeMirrorXML.Tag rootTag = schemaInfo.addTag(null);
        rootTag.addChildren(new String[]{"fsp"});
        ComponentRegistry.getInstance().forEach(comp -> {
            String parentTag = comp.getTag();
            if (parentTag.startsWith("#")) {
                return;
            }
            CodeMirrorXML.Tag tag = schemaInfo.addTag(parentTag);
            rootTag.addChildren(new String[]{parentTag});
            for (String childTag : comp.getChildTags().keySet()) {
                for (ComponentDefinition childDef : ComponentRegistry.getInstance().getMatching(childTag)) {
                    String cTag = childDef.getTag();
                    if (cTag.startsWith("#") || !childDef.isParentTag(parentTag)) continue;
                    tag.addChildren(new String[]{cTag});
                }
            }
            MainController.addAttributes(comp.getSetters(), tag);
            MainController.addAttributes(comp.getFactoryParameters(), tag);
        });
    }
}

