/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.sparkline;

import org.apache.commons.lang3.StringUtils;
import org.fujion.common.MiscUtil;
import org.fujion.sparkline.AbstractPlot;
import org.fujion.sparkline.BarPlot;
import org.fujion.sparkline.BoxPlot;
import org.fujion.sparkline.BulletPlot;
import org.fujion.sparkline.DiscretePlot;
import org.fujion.sparkline.LinePlot;
import org.fujion.sparkline.PiePlot;
import org.fujion.sparkline.TristatePlot;

public enum SparklineType {
    LINE(LinePlot.class),
    BAR(BarPlot.class),
    TRISTATE(TristatePlot.class),
    DISCRETE(DiscretePlot.class),
    BULLET(BulletPlot.class),
    PIE(PiePlot.class),
    BOX(BoxPlot.class);

    private final Class<? extends AbstractPlot> optionClass;

    public static SparklineType fromClass(Class<? extends AbstractPlot> clazz) {
        return SparklineType.valueOf(StringUtils.removeEnd((String)clazz.getSimpleName().toUpperCase(), (String)"PLOT"));
    }

    private SparklineType(Class<? extends AbstractPlot> optionClass) {
        this.optionClass = optionClass;
    }

    public AbstractPlot createPlot() {
        try {
            return this.optionClass.newInstance();
        }
        catch (Exception e) {
            throw MiscUtil.toUnchecked((Throwable)e);
        }
    }

    public String toString() {
        return this.name().toLowerCase();
    }
}

