/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.sparkline;

import java.util.Map;
import org.fujion.annotation.Component;
import org.fujion.common.MiscUtil;
import org.fujion.component.BaseUIComponent;
import org.fujion.sparkline.AbstractPlot;
import org.fujion.sparkline.CommonOptions;
import org.fujion.sparkline.SparklineType;

@Component(tag="sparkline", widgetModule="fujion-sparkline", widgetClass="Sparkline", parentTag={"*"}, description="Sparkline component.")
public class Sparkline
extends BaseUIComponent {
    private final CommonOptions commonOptions = new CommonOptions();
    private AbstractPlot plotOptions;
    private Object data;

    public void run() {
        this.invoke("run", new Object[]{this.data, this.commonOptions, this.getPlot()});
    }

    public void clear() {
        this.invoke("clear", new Object[0]);
    }

    @Component.PropertyGetter(value="type", description="The type of sparkline.")
    public SparklineType getType() {
        return this.commonOptions.type;
    }

    @Component.PropertySetter(value="type", defaultValue="line", description="The type of sparkline.")
    public void setType(SparklineType type) {
        this.commonOptions.type = type = (SparklineType)((Object)this.defaultify((Object)type, (Object)SparklineType.LINE));
        if (this.propertyChange("type", (Object)this.commonOptions.type, (Object)this.commonOptions.type, false)) {
            this.plotOptions = null;
        }
    }

    public AbstractPlot getPlot() {
        return this.plotOptions != null ? this.plotOptions : (this.plotOptions = this.commonOptions.type.createPlot());
    }

    public <T extends AbstractPlot> T newPlot(Class<T> clazz) {
        try {
            AbstractPlot plot = (AbstractPlot)((Object)clazz.newInstance());
            this.setType(plot.getType());
            this.plotOptions = plot;
            return (T)((Object)plot);
        }
        catch (Exception e) {
            throw MiscUtil.toUnchecked((Throwable)e);
        }
    }

    public void setData(double[] data) {
        this.data = data;
    }

    public void setData(int[] data) {
        this.data = data;
    }

    protected void _initProps(Map<String, Object> props) {
        super._initProps(props);
        props.put("trackrender", true);
    }

    @Component.PropertySetter(value="data", defer=true, description="Comma-delimited list of numeric values.")
    private void setData(String data) {
        String[] pcs = data.split(",");
        double[] values = new double[pcs.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = Double.parseDouble(pcs[i].trim());
        }
        this.data = values;
        this.run();
    }

    @Component.PropertyGetter(value="chartRangeMax", description="The maximum value to use for the range of Y values of the chart. Defaults to the maximum value supplied.")
    public Double getChartRangeMax() {
        return this.commonOptions.chartRangeMax;
    }

    @Component.PropertySetter(value="chartRangeMax", description="The maximum value to use for the range of Y values of the chart. Defaults to the maximum value supplied.")
    public void setChartRangeMax(Double chartRangeMax) {
        this.commonOptions.chartRangeMax = chartRangeMax;
        this.propertyChange("chartRangeMax", this.commonOptions.chartRangeMax, this.commonOptions.chartRangeMax, false);
    }

    @Component.PropertyGetter(value="chartRangeMin", description="The minimum value to use for the range of Y values of the chart. Defaults to the minimum value supplied.")
    public Double getChartRangeMin() {
        return this.commonOptions.chartRangeMin;
    }

    @Component.PropertySetter(value="chartRangeMin", description="The minimum value to use for the range of Y values of the chart. Defaults to the minimum value supplied.")
    public void setChartRangeMin(Double chartRangeMin) {
        this.commonOptions.chartRangeMin = chartRangeMin;
        this.propertyChange("chartRangeMin", this.commonOptions.chartRangeMin, this.commonOptions.chartRangeMin, false);
    }

    @Component.PropertyGetter(value="fillColor", description="The color used to fill the area under the graph as a CSS value.")
    public String getFillColor() {
        return this.commonOptions.fillColor;
    }

    @Component.PropertySetter(value="fillColor", description="The color used to fill the area under the graph as a CSS value.")
    public void setFillColor(String fillColor) {
        this.commonOptions.fillColor = fillColor;
        this.propertyChange("fillColor", this.commonOptions.fillColor, this.commonOptions.fillColor, false);
    }

    @Component.PropertyGetter(value="lineColor", description="Used by line and discrete charts to specify the color of the line drawn as a CSS values string.")
    public String getLineColor() {
        return this.commonOptions.lineColor;
    }

    @Component.PropertySetter(value="lineColor", description="Used by line and discrete charts to specify the color of the line drawn as a CSS values string.")
    public void setLineColor(String lineColor) {
        this.commonOptions.lineColor = lineColor;
        this.propertyChange("lineColor", this.commonOptions.lineColor, this.commonOptions.lineColor, false);
    }
}

