/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.spinjs;

import java.util.Arrays;
import org.fujion.annotation.Component;
import org.fujion.common.StrUtil;
import org.fujion.component.BaseUIComponent;
import org.fujion.spinjs.SpinJSOptions;
import org.springframework.util.Assert;

@Component(tag="spinjs", widgetModule="fujion-spinjs", widgetClass="SpinJS", parentTag={"*"}, description="Spin-js component.")
public class SpinJS
extends BaseUIComponent {
    private final SpinJSOptions options = new SpinJSOptions();
    private boolean running;

    public boolean isRunning() {
        return this.running;
    }

    @Component.PropertySetter(value="start", defer=true, defaultValue="false", description="Starts or stops the animation.")
    public void start(boolean start) {
        if (start) {
            this.start();
        } else {
            this.stop();
        }
    }

    public void start() {
        if (!this.running) {
            this.invoke("start", new Object[]{this.options});
            this.running = true;
        }
    }

    public void stop() {
        if (this.running) {
            this.invoke("stop", new Object[0]);
            this.running = false;
        }
    }

    @Component.PropertyGetter(value="lines", description="The number of lines to draw.")
    public Integer getLines() {
        return this.options.lines;
    }

    @Component.PropertySetter(value="lines", defaultValue="12", description="The number of lines to draw.")
    public void setLines(Integer lines) {
        this.options.lines = lines;
        this.propertyChange("lines", this.options.lines, this.options.lines, false);
    }

    @Component.PropertyGetter(value="linelength", description="The length of each line.")
    public Integer getLineLength() {
        return this.options.length;
    }

    @Component.PropertySetter(value="linelength", defaultValue="7", description="The length of each line.")
    public void setLineLength(Integer length) {
        this.options.length = length;
        this.propertyChange("linelength", this.options.length, this.options.length, false);
    }

    @Component.PropertyGetter(value="linewidth", description="The width of each line.")
    public Integer getLineWidth() {
        return this.options.width;
    }

    @Component.PropertySetter(value="linewidth", defaultValue="5", description="The width of each line.")
    public void setLineWidth(Integer width) {
        this.options.width = width;
        this.propertyChange("linewidth", this.options.width, this.options.width, false);
    }

    @Component.PropertyGetter(value="radius", description="The radius of the inner circle.")
    public Integer getRadius() {
        return this.options.radius;
    }

    @Component.PropertySetter(value="radius", defaultValue="10", description="The radius of the inner circle.")
    public void setRadius(Integer radius) {
        this.options.radius = radius;
        this.propertyChange("radius", this.options.radius, this.options.radius, false);
    }

    @Component.PropertyGetter(value="scale", description="The overall size of the spinner.")
    public Double getScale() {
        return this.options.scale;
    }

    @Component.PropertySetter(value="scale", defaultValue="1", description="The overall size of the spinner.")
    public void setScale(Double scale) {
        this.options.scale = scale;
        this.propertyChange("scale", this.options.scale, this.options.scale, false);
    }

    @Component.PropertyGetter(value="corners", description="The corner roundness.")
    public Double getCorners() {
        return this.options.corners;
    }

    @Component.PropertySetter(value="corners", defaultValue="1", description="The corner roundness.")
    public void setCorners(Double corners) {
        Assert.isTrue((corners == null || corners >= 0.0 && corners <= 1.0 ? 1 : 0) != 0, () -> "Property \"corners\" must be between 0 and 1, inclusive");
        this.options.corners = corners;
        this.propertyChange("corners", this.options.corners, this.options.corners, false);
    }

    @Component.PropertyGetter(value="linecolor", description="The line color(s).  Separate multiple colors with commas.")
    public String getLineColor() {
        return this._formatColors(this.options.color$array);
    }

    @Component.PropertySetter(value="linecolor", defaultValue="#000", description="The line color(s).  Separate multiple colors with commas.")
    public void setLineColor(String color) {
        String[] colors = color == null ? null : color.replace(" ", "").split("\\,");
        this.options.color$array = colors;
        this.propertyChange("linecolor", this.options.color$array, colors, false);
    }

    @Component.PropertyGetter(value="fadecolor", description="The color(s) for the fade effect.  Separate multiple colors with commas.")
    public String getFadeColor() {
        return this._formatColors(this.options.fadeColor$array);
    }

    @Component.PropertySetter(value="fadecolor", defaultValue="transparent", description="The color(s) for the fade effect.  Separate multiple colors with commas.")
    public void setFadeColor(String fadeColor) {
        String[] colors = fadeColor == null ? null : fadeColor.replace(" ", "").split("\\,");
        this.options.fadeColor$array = colors;
        this.propertyChange("fadecolor", this.options.fadeColor$array, colors, false);
    }

    private String _formatColors(String[] colors) {
        return colors != null ? StrUtil.fromList(Arrays.asList(colors), (String)",") : null;
    }

    @Component.PropertyGetter(value="opacity", description="The opacity of the lines.")
    public Double getOpacity() {
        return this.options.opacity;
    }

    @Component.PropertySetter(value="opacity", defaultValue="0.25", description="The opacity of the lines.")
    public void setOpacity(Double opacity) {
        Assert.isTrue((opacity == null || opacity >= 0.0 && opacity <= 1.0 ? 1 : 0) != 0, () -> "Property \"opacity\" must be between 0 and 1, inclusive");
        this.options.opacity = opacity;
        this.propertyChange("opacity", this.options.opacity, this.options.opacity, false);
    }

    @Component.PropertyGetter(value="rotate", description="The rotation offset.")
    public Integer getRotate() {
        return this.options.rotate;
    }

    @Component.PropertySetter(value="rotate", defaultValue="0", description="The rotation offset.")
    public void setRotate(Integer rotate) {
        this.options.rotate = rotate;
        this.propertyChange("rotate", this.options.rotate, this.options.rotate, false);
    }

    @Component.PropertyGetter(value="clockwise", description="If true, the rotation is clockwise.")
    public Boolean isClockwise() {
        return this.options.direction == null ? null : Boolean.valueOf(this.options.direction > 0);
    }

    @Component.PropertySetter(value="clockwise", defaultValue="true", description="If true, the rotation is clockwise.")
    public void setClockwise(Boolean clockwise) {
        Integer direction;
        this.options.direction = direction = clockwise == null ? null : Integer.valueOf(clockwise != false ? 1 : -1);
        this.propertyChange("clockwise", this.options.direction, this.options.direction, false);
    }

    @Component.PropertyGetter(value="speed", description="Rounds per second.")
    public Integer getSpeed() {
        return this.options.speed;
    }

    @Component.PropertySetter(value="speed", defaultValue="1", description="Rounds per second.")
    public void setSpeed(Integer speed) {
        this.options.speed = speed;
        this.propertyChange("speed", this.options.speed, this.options.speed, false);
    }

    @Component.PropertyGetter(value="trail", description="The after-glow percentage.")
    public Integer getTrail() {
        return this.options.trail;
    }

    @Component.PropertySetter(value="trail", defaultValue="100", description="The after-glow percentage.")
    public void setTrail(Integer trail) {
        Assert.isTrue((trail == null || (double)trail.intValue() >= 0.0 && (double)trail.intValue() <= 100.0 ? 1 : 0) != 0, () -> "Property \"trail\" must be between 0 and 100, inclusive");
        this.options.trail = trail;
        this.propertyChange("trail", this.options.trail, this.options.trail, false);
    }

    @Component.PropertyGetter(value="top", description="The top position relative to parent.")
    public String getTop() {
        return this.options.top;
    }

    @Component.PropertySetter(value="top", defaultValue="50%", description="The top position relative to parent.")
    public void setTop(String top) {
        this.options.top = top;
        this.propertyChange("top", this.options.top, this.options.top, false);
    }

    @Component.PropertyGetter(value="left", description="The left position relative to parent.")
    public String getLeft() {
        return this.options.left;
    }

    @Component.PropertySetter(value="left", defaultValue="50%", description="The left position relative to parent.")
    public void setLeft(String left) {
        this.options.left = left;
        this.propertyChange("left", this.options.left, this.options.left, false);
    }

    @Component.PropertyGetter(value="shadow", description="The box-shadow for the lines.")
    public String getShadow() {
        return this.options.shadow;
    }

    @Component.PropertySetter(value="shadow", defaultValue="none", description="The box-shadow for the lines.")
    public void setShadow(String shadow) {
        this.options.shadow = shadow;
        this.propertyChange("shadow", this.options.shadow, this.options.shadow, false);
    }
}

