/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.test;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import org.fujion.common.MiscUtil;
import org.fujion.common.StrUtil;
import org.fujion.test.MockConfig;
import org.fujion.test.MockEnvironment;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.springframework.core.io.Resource;

public class MockTest {
    public static Class<? extends MockEnvironment> mockEnvironmentClass = MockEnvironment.class;
    public static MockConfig rootConfig = new MockConfig(new String[]{"classpath:/META-INF/fujion-dispatcher-servlet.xml"}, null);
    public static MockConfig childConfig;
    private static MockEnvironment mockEnvironment;
    private static int initCount;

    @BeforeClass
    public static void beforeClass() throws Exception {
        ++initCount;
        MockTest.getMockEnvironment();
    }

    @AfterClass
    public static void afterClass() {
        int n = initCount = initCount <= 0 ? 0 : initCount - 1;
        if (initCount == 0 && mockEnvironment != null) {
            System.out.println("Destroying mock environment...");
            mockEnvironment.close();
            mockEnvironment = null;
        }
    }

    public static MockEnvironment getMockEnvironment() {
        if (mockEnvironment == null) {
            try {
                System.out.println("Initializing mock environment...");
                mockEnvironment = mockEnvironmentClass.newInstance();
                mockEnvironment.init(rootConfig, childConfig);
            }
            catch (Exception e) {
                throw MiscUtil.toUnchecked((Throwable)e);
            }
        }
        return mockEnvironment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTextFromResource(String resourceName) throws IOException {
        Resource resource = MockTest.getMockEnvironment().getRootContext().getResource("classpath:" + resourceName);
        InputStream is = resource.getInputStream();
        StringWriter writer = new StringWriter();
        char[] buffer = new char[1024];
        try {
            int n;
            BufferedReader reader = new BufferedReader(new InputStreamReader(is, StrUtil.UTF8));
            while ((n = reader.read(buffer)) != -1) {
                ((Writer)writer).write(buffer, 0, n);
            }
        }
        finally {
            is.close();
        }
        return ((Object)writer).toString();
    }
}

