/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.test;

import java.util.List;
import org.fujion.annotation.ComponentDefinition;
import org.fujion.client.ExecutionContext;
import org.fujion.component.BaseComponent;
import org.fujion.component.Page;
import org.fujion.component.Treenode;
import org.fujion.component.Treeview;
import org.fujion.page.PageDefinition;
import org.fujion.page.PageElement;
import org.fujion.page.PageUtil;
import org.fujion.test.MockTest;
import org.junit.Assert;
import org.junit.Test;

public class FujionTest
extends MockTest {
    private final String[] nodes = new String[]{"1.1", "2.1", "3.1", "2.2", "1.2", "1.3", "2.1", "3.1", "2.2"};

    private PageDefinition getPageDefinition(String file) {
        String path = "file://" + ExecutionContext.getSession().getServletContext().getRealPath(file);
        return PageUtil.getPageDefinition((String)path);
    }

    private List<BaseComponent> createPage(String file, BaseComponent parent) {
        PageDefinition pagedef = this.getPageDefinition(file);
        return PageUtil.createPage((PageDefinition)pagedef, (BaseComponent)parent);
    }

    @Test
    public void testParser() {
        PageDefinition pagedef = this.getPageDefinition("test.fsp");
        PageElement pgele = (PageElement)pagedef.getRootElement().getChildren().iterator().next();
        Page page = ExecutionContext.getPage();
        ComponentDefinition cmpdef = pgele.getDefinition();
        Assert.assertEquals((Object)"page", (Object)cmpdef.getTag());
        Assert.assertEquals(Page.class, (Object)cmpdef.getComponentClass());
        Assert.assertEquals((Object)"page", pgele.getAttributes().get("name"));
        List roots = PageUtil.createPage((PageDefinition)pagedef, (BaseComponent)page, null);
        Assert.assertEquals((long)1L, (long)roots.size());
        BaseComponent root = (BaseComponent)roots.get(0);
        Assert.assertSame((Object)page, (Object)root);
        Assert.assertEquals((Object)"page", (Object)page.getName());
        Assert.assertEquals((Object)"The Page Title", (Object)page.getTitle());
    }

    @Test
    public void testTreeview() {
        Treeview tv = (Treeview)this.createPage("treeview.fsp", null).get(0);
        int index = 0;
        for (Treenode node : tv) {
            Assert.assertEquals((Object)this.nodes[index++], (Object)node.getLabel());
        }
        Assert.assertEquals((long)this.nodes.length, (long)index);
    }
}

