/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.test;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.security.Principal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpHeaders;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.WebSocketExtension;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;

public class MockWebSocketSession
implements WebSocketSession {
    private URI uri;
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private Principal principal;
    int messageSizeLimitText = 5000;
    int messageSizeLimitBinary = 5000;
    boolean open = true;

    public MockWebSocketSession() throws Exception {
        this("http://mock.domain.org");
    }

    public MockWebSocketSession(String uri) throws Exception {
        this.uri = new URI(uri);
        this.principal = new Principal(){

            @Override
            public String getName() {
                return "mock-principle";
            }
        };
    }

    public String getId() {
        return "mock-id";
    }

    public URI getUri() {
        return this.uri;
    }

    public HttpHeaders getHandshakeHeaders() {
        return null;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public InetSocketAddress getLocalAddress() {
        return null;
    }

    public InetSocketAddress getRemoteAddress() {
        return null;
    }

    public String getAcceptedProtocol() {
        return null;
    }

    public void setTextMessageSizeLimit(int messageSizeLimit) {
        this.messageSizeLimitText = messageSizeLimit;
    }

    public int getTextMessageSizeLimit() {
        return this.messageSizeLimitText;
    }

    public void setBinaryMessageSizeLimit(int messageSizeLimit) {
        this.messageSizeLimitBinary = messageSizeLimit;
    }

    public int getBinaryMessageSizeLimit() {
        return this.messageSizeLimitBinary;
    }

    public List<WebSocketExtension> getExtensions() {
        return null;
    }

    public void sendMessage(WebSocketMessage<?> message) throws IOException {
    }

    public boolean isOpen() {
        return this.open;
    }

    public void close() throws IOException {
        this.open = false;
    }

    public void close(CloseStatus status) throws IOException {
        this.open = false;
    }
}

