/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.test;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.fujion.annotation.ComponentDefinition;
import org.fujion.client.ExecutionContext;
import org.fujion.component.BaseComponent;
import org.fujion.component.Button;
import org.fujion.component.Combobox;
import org.fujion.component.Comboitem;
import org.fujion.component.Label;
import org.fujion.component.Page;
import org.fujion.component.Radiobutton;
import org.fujion.component.Radiogroup;
import org.fujion.component.Textbox;
import org.fujion.component.Toolbar;
import org.fujion.component.Treenode;
import org.fujion.component.Treeview;
import org.fujion.page.PageDefinition;
import org.fujion.page.PageElement;
import org.fujion.page.PageUtil;
import org.fujion.test.MockTest;
import org.fujion.test.TestBinder;
import org.junit.Assert;
import org.junit.Test;

public class FujionTest
extends MockTest {
    private static final String GREEN = "green";
    private static final String RED = "red";
    private static final String ORANGE = "orange";
    private final String[] nodes = new String[]{"1.1", "2.1", "3.1", "2.2", "1.2", "1.3", "2.1", "3.1", "2.2"};

    private PageDefinition getPageDefinition(String file) {
        String path = "file://" + ExecutionContext.getSession().getServletContext().getRealPath(file);
        return PageUtil.getPageDefinition((String)path);
    }

    private List<BaseComponent> createPage(String file, BaseComponent parent) {
        PageDefinition pagedef = this.getPageDefinition(file);
        return PageUtil.createPage((PageDefinition)pagedef, (BaseComponent)parent);
    }

    @Test
    public void testParser() {
        PageDefinition pagedef = this.getPageDefinition("test.fsp");
        PageElement pgele = (PageElement)pagedef.getRootElement().getChildren().iterator().next();
        Page page = ExecutionContext.getPage();
        ComponentDefinition cmpdef = pgele.getDefinition();
        Assert.assertEquals((Object)"page", (Object)cmpdef.getTag());
        Assert.assertEquals(Page.class, (Object)cmpdef.getComponentClass());
        Assert.assertEquals((Object)"page", pgele.getAttributes().get("name"));
        List roots = PageUtil.createPage((PageDefinition)pagedef, (BaseComponent)page, null);
        Assert.assertEquals((long)1L, (long)roots.size());
        BaseComponent root = (BaseComponent)roots.get(0);
        Assert.assertSame((Object)page, (Object)root);
        Assert.assertEquals((Object)"page", (Object)page.getName());
        Assert.assertEquals((Object)"The Page Title", (Object)page.getTitle());
    }

    @Test
    public void testNamespace() {
        PageDefinition pagedef = this.getPageDefinition("nstest.fsp");
        BaseComponent root = (BaseComponent)pagedef.materialize(null).get(0);
        BaseComponent ref = root.findByName("myinner");
        Assert.assertNotNull((Object)ref);
        BaseComponent cmp = ref.findByName("mycomp");
        Assert.assertTrue((boolean)(cmp instanceof Button));
        cmp = ref.findByName("^.mycomp");
        Assert.assertTrue((boolean)(cmp instanceof Label));
        cmp = ref.findByName("mycomp2");
        Assert.assertTrue((boolean)(cmp instanceof Toolbar));
        cmp = ref.findByName("^.mycomp2");
        Assert.assertNull((Object)cmp);
        cmp = ref.findByName("^.myinner.mycomp2");
        Assert.assertTrue((boolean)(cmp instanceof Toolbar));
        cmp = ref.findByName("^.mycomp.myinner.mycomp");
        Assert.assertTrue((boolean)(cmp instanceof Button));
    }

    @Test
    public void testBinding() {
        PageDefinition pagedef = this.getPageDefinition("binding.fsp");
        TestBinder binder = new TestBinder();
        TestBinder.TestModel model = (TestBinder.TestModel)((Object)binder.getModel());
        Map<String, TestBinder> args = Collections.singletonMap("binder", binder);
        BaseComponent root = (BaseComponent)pagedef.materialize(null, args).get(0);
        this.testBinding(root, model, GREEN);
        model.setColor(RED);
        this.testBinding(root, model, RED);
        ((Textbox)root.findByName("textbox", Textbox.class)).setValue((Object)GREEN);
        this.testBinding(root, model, GREEN);
        ((Combobox)root.findByName("combobox", Combobox.class)).setSelectedIndex(1);
        this.testBinding(root, model, RED);
        ((Radiobutton)root.findByName("rbGreen", Radiobutton.class)).setChecked(true);
        this.testBinding(root, model, GREEN);
        ((Radiobutton)root.findByName("rbRed", Radiobutton.class)).setChecked(true);
        this.testBinding(root, model, RED);
        ((Comboitem)root.findByName("cbiGreen", Comboitem.class)).setSelected(true);
        this.testBinding(root, model, GREEN);
        ((Comboitem)root.findByName("cbiRed", Comboitem.class)).setSelected(true);
        this.testBinding(root, model, RED);
        ((Label)root.findByName("label", Label.class)).setLabel(GREEN);
        this.testBinding(root, model, RED, GREEN, false);
        model.setColor(ORANGE);
        this.testBinding(root, model, ORANGE, ORANGE, true);
        model.setColor(RED);
        this.testBinding(root, model, RED);
        ((Textbox)root.findByName("textbox", Textbox.class)).setValue(null);
        this.testBinding(root, model, null, null, true);
        model.setColor(GREEN);
        this.testBinding(root, model, GREEN);
    }

    private void testBinding(BaseComponent root, TestBinder.TestModel model, String value) {
        this.testBinding(root, model, value, value, false);
    }

    private void testBinding(BaseComponent root, TestBinder.TestModel model, String value, String labelValue, boolean noneSelected) {
        Textbox textbox = (Textbox)root.findByName("textbox", Textbox.class);
        Label label = (Label)root.findByName("label", Label.class);
        Combobox combobox = (Combobox)root.findByName("combobox", Combobox.class);
        Comboitem cbi = combobox.getSelectedItem();
        Radiogroup radiogroup = (Radiogroup)root.findByName("radiogroup", Radiogroup.class);
        Radiobutton rbtn = radiogroup.getSelected();
        Assert.assertEquals((Object)value, (Object)model.getColor());
        Assert.assertEquals((Object)value, (Object)textbox.getValue());
        Assert.assertEquals((Object)labelValue, (Object)label.getLabel());
        if (noneSelected) {
            Assert.assertNull((Object)cbi);
            Assert.assertNull((Object)rbtn);
            Assert.assertNull((Object)combobox.getValue());
        } else {
            Assert.assertEquals((Object)value, (Object)combobox.getValue());
            Assert.assertEquals((Object)value, (Object)cbi.getLabel());
            Assert.assertEquals((Object)value, (Object)rbtn.getLabel());
        }
    }

    @Test
    public void testTreeview() {
        Treeview tv = (Treeview)this.createPage("treeview.fsp", null).get(0);
        int index = 0;
        for (Treenode node : tv) {
            Assert.assertEquals((Object)this.nodes[index++], (Object)node.getLabel());
        }
        Assert.assertEquals((long)this.nodes.length, (long)index);
    }
}

