/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.test;

import java.util.List;
import org.fujion.annotation.ComponentDefinition;
import org.fujion.client.ExecutionContext;
import org.fujion.component.BaseComponent;
import org.fujion.component.Page;
import org.fujion.page.PageDefinition;
import org.fujion.page.PageElement;
import org.fujion.page.PageUtil;
import org.fujion.test.MockTest;
import org.junit.Assert;
import org.junit.Test;

public class FujionTest
extends MockTest {
    @Test
    public void parserTests() {
        PageDefinition pagedef = this.getPageDefinition("web/fujion/test/test.fsp");
        PageElement pgele = (PageElement)pagedef.getRootElement().getChildren().iterator().next();
        Page page = ExecutionContext.getPage();
        ComponentDefinition cmpdef = pgele.getDefinition();
        Assert.assertEquals((Object)"page", (Object)cmpdef.getTag());
        Assert.assertEquals(Page.class, (Object)cmpdef.getComponentClass());
        Assert.assertEquals((Object)"page", pgele.getAttributes().get("name"));
        List roots = PageUtil.createPage((PageDefinition)pagedef, (BaseComponent)page, null);
        Assert.assertEquals((long)1L, (long)roots.size());
        BaseComponent root = (BaseComponent)roots.get(0);
        Assert.assertSame((Object)page, (Object)root);
        Assert.assertEquals((Object)"page", (Object)page.getName());
        Assert.assertEquals((Object)"The Page Title", (Object)page.getTitle());
        BaseComponent el_expressions = page.findByName("el_expressions");
        Assert.assertNotNull((Object)el_expressions);
        this.checkEL(el_expressions, 0, "org.fujion.expression.ELEvaluator");
        this.checkEL(el_expressions, 1, "This is a test.");
        this.checkEL(el_expressions, 2, 20);
        BaseComponent conditional_blocks = page.findByName("conditional_blocks");
        Assert.assertNotNull((Object)conditional_blocks);
        Assert.assertNotNull((Object)page.findByName("if_include"));
        Assert.assertNotNull((Object)page.findByName("unless_include"));
        Assert.assertNull((Object)page.findByName("if_exclude"));
        Assert.assertNull((Object)page.findByName("unless_exclude"));
        BaseComponent namespaces = page.findByName("namespaces");
        Assert.assertNotNull((Object)namespaces);
        this.checkNS(namespaces, "ns1_1", true);
        this.checkNS(namespaces, "ns2_1", false);
        this.checkNS(namespaces, "ns3_1", false);
        this.checkNS(namespaces, "ns2/ns1_1", false);
        this.checkNS(namespaces, "ns2/ns2_1", true);
        this.checkNS(namespaces, "ns2/ns3_1", false);
        this.checkNS(namespaces, "ns3/ns1_1", false);
        this.checkNS(namespaces, "ns3/ns2_1", false);
        this.checkNS(namespaces, "ns3/ns3_1", false);
        this.checkNS(namespaces, "ns2/ns3/ns1_1", false);
        this.checkNS(namespaces, "ns2/ns3/ns2_1", false);
        this.checkNS(namespaces, "ns2/ns3/ns3_1", true);
        BaseComponent labels = page.findByName("labels");
        Assert.assertNotNull((Object)labels);
        this.checkLabel(labels, 0, "This is a test.");
        this.checkLabel(labels, 1, "This contains a label reference: This is a test.");
        this.checkLabel(labels, 2, "This contains a recursive reference: This contains a label reference: This is a test.");
        this.checkLabel(labels, 3, "This introduces an infinite recursion: Infinite recursion: test3");
        this.checkLabel(labels, 4, "Demonstration of a dotted name.");
        BaseComponent tag_libraries = page.findByName("tag_libraries");
        Assert.assertNotNull((Object)tag_libraries);
        Assert.assertEquals((Object)"This is a test.", (Object)tag_libraries.getFirstChild().getData());
    }

    private void checkEL(BaseComponent parent, int childIndex, Object expectedValue) {
        BaseComponent comp = parent.getChildAt(childIndex);
        Assert.assertEquals((Object)expectedValue, (Object)comp.getAttribute("el"));
    }

    private void checkNS(BaseComponent ref, String path, boolean notNull) {
        BaseComponent comp = ref.findByName(path);
        Assert.assertTrue((boolean)(notNull ? comp != null : comp == null));
    }

    private void checkLabel(BaseComponent parent, int childIndex, String expectedValue) {
        BaseComponent comp = parent.getChildAt(childIndex);
        Assert.assertEquals((Object)expectedValue, (Object)comp.getData());
    }
}

