/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.test;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import org.apache.catalina.startup.Tomcat;
import org.springframework.util.SocketUtils;

public class MockWebServer {
    private Tomcat server;
    private final int port;

    public MockWebServer() throws Exception {
        this(SocketUtils.findAvailableTcpPort());
    }

    public MockWebServer(int port) throws Exception {
        this.port = port;
        this.server = new Tomcat();
        this.server.setBaseDir(this.getTargetPath("tomcat-" + port));
        this.server.setPort(this.port);
        this.server.addWebapp("", this.getTargetPath("classes"));
    }

    private String getTargetPath(String path) {
        return new File("./target/" + path + "/").getAbsolutePath();
    }

    public void start() throws Exception {
        this.server.start();
    }

    public void stop() throws Exception {
        this.server.stop();
        this.server = null;
    }

    public int getPort() {
        return this.port;
    }

    public InputStream request(String resourcePath) throws Exception {
        URL url = new URL("http://localhost:" + this.port + "/" + resourcePath);
        return url.openConnection().getInputStream();
    }
}

