/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.test;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import org.fujion.client.ClientRequest;
import org.fujion.client.ExecutionContext;
import org.fujion.client.Synchronizer;
import org.fujion.component.Page;
import org.fujion.event.EventQueue;
import org.fujion.spring.ClasspathMessageSource;
import org.fujion.test.MockClientRequest;
import org.fujion.test.MockConfig;
import org.fujion.test.MockServletContext;
import org.fujion.test.MockSession;
import org.fujion.test.MockWebSocketSession;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.XmlWebApplicationContext;

public class MockEnvironment {
    private MockSession session;
    private MockClientRequest clientRequest;
    private MockServletContext servletContext;
    private XmlWebApplicationContext rootContext;
    private XmlWebApplicationContext childContext;
    private final Map<String, Object> browserInfo = new HashMap<String, Object>();
    private final Map<String, Object> clientRequestMap = new HashMap<String, Object>();

    public void init(MockConfig rootConfig, MockConfig childConfig) throws Exception {
        this.servletContext = this.initServletContext(new MockServletContext());
        this.rootContext = this.initAppContext(rootConfig, null);
        this.servletContext.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, this.rootContext);
        this.rootContext.refresh();
        MockWebSocketSession socket = new MockWebSocketSession();
        this.session = new MockSession(this.servletContext, socket);
        this.initBrowserInfoMap(this.browserInfo);
        this.clientRequestMap.put("data", this.browserInfo);
        this.initClientRequestMap(this.clientRequestMap);
        this.clientRequest = new MockClientRequest(this.session, this.clientRequestMap);
        this.initExecutionContext();
        Page page = this.session.getPage();
        Page._init((Page)page, (ClientRequest)this.clientRequest, (Synchronizer)this.session.getSynchronizer());
        page = this.initPage(page);
        if (childConfig != null) {
            this.childContext = this.initAppContext(childConfig, (ApplicationContext)this.rootContext);
            this.childContext.refresh();
        }
    }

    public void close() {
        this.session.destroy();
        this.rootContext.close();
    }

    protected XmlWebApplicationContext createApplicationContext() {
        return new XmlWebApplicationContext();
    }

    protected MockServletContext initServletContext(MockServletContext servletContext) {
        return servletContext;
    }

    protected void initExecutionContext() {
        ExecutionContext.put((String)"fujion_request", (Object)((Object)this.clientRequest));
    }

    protected void initClientRequestMap(Map<String, Object> map) {
        map.put("pid", this.session.getPage().getId());
        map.put("type", "mock");
    }

    protected XmlWebApplicationContext initAppContext(MockConfig config, ApplicationContext parent) {
        XmlWebApplicationContext appContext = this.createApplicationContext();
        appContext.setServletContext((ServletContext)this.servletContext);
        if (parent == null) {
            ClasspathMessageSource.getInstance().setResourceLoader((ResourceLoader)appContext);
        } else {
            appContext.setParent(parent);
        }
        if (config.configLocations != null) {
            appContext.setConfigLocations(config.configLocations);
        }
        if (config.profiles != null && config.profiles.length > 0) {
            ConfigurableEnvironment env = appContext.getEnvironment();
            env.setDefaultProfiles(new String[]{parent == null ? config.profiles[0] : "dummy"});
            env.setActiveProfiles(config.profiles);
        }
        return appContext;
    }

    protected void initBrowserInfoMap(Map<String, Object> browserInfo) {
        browserInfo.put("requestURL", "http://mock.org/mock.fsp");
    }

    protected Page initPage(Page page) {
        return page;
    }

    public ApplicationContext getRootContext() {
        return this.rootContext;
    }

    public ApplicationContext getChildContext() {
        return this.childContext;
    }

    public MockSession getSession() {
        return this.session;
    }

    public boolean flushEvents() {
        EventQueue queue = this.session.getPage().getEventQueue();
        boolean flushed = !queue.isEmpty();
        queue.processAll();
        return flushed;
    }
}

