/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.testharness;

import java.util.Date;
import org.fujion.annotation.EventHandler;
import org.fujion.annotation.WiredComponent;
import org.fujion.component.BaseComponent;
import org.fujion.component.Button;
import org.fujion.component.Progressbar;
import org.fujion.component.Timer;
import org.fujion.event.TimerEvent;
import org.fujion.testharness.BaseController;

public class TimerController
extends BaseController {
    @WiredComponent
    private Timer timer;
    @WiredComponent
    private Button btnToggleTimer;
    @WiredComponent
    private Progressbar pbTimer;

    public void afterInitialized(BaseComponent root) {
        super.afterInitialized(root);
        this.setTimerButtonState(false);
    }

    @EventHandler(value={"click"}, target={"@btnToggleTimer"})
    private void btnToggleTimerHandler() {
        if (this.timer.isRunning()) {
            this.timer.stop();
            this.log("Timer was stopped.");
        } else {
            this.pbTimer.setMaxValue(this.timer.getRepeat() + 1);
            this.setTimerProgressbarState(0);
            this.timer.start();
            this.log("Timer was started.");
        }
        this.setTimerButtonState(this.timer.isRunning());
    }

    @EventHandler(value={"timer"}, target={"timer"})
    public void onTimer(TimerEvent event) {
        int count = event.getCount();
        this.log("Timer event: " + event.getTarget().getName() + " # " + count + " @ " + new Date().toString());
        this.setTimerButtonState(event.isRunning());
        this.setTimerProgressbarState(count);
        if (!event.isRunning()) {
            this.log("Timer finished.");
        }
    }

    private void setTimerProgressbarState(int count) {
        this.pbTimer.setValue(count);
        this.pbTimer.setLabel(count + " of " + this.pbTimer.getMaxValue());
    }

    private void setTimerButtonState(boolean running) {
        if (!running) {
            this.btnToggleTimer.setLabel("Start");
            this.btnToggleTimer.addClass("flavor:btn-success");
        } else {
            this.btnToggleTimer.setLabel("Stop");
            this.btnToggleTimer.addClass("flavor:btn-danger");
        }
    }
}

