/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.testharness;

import java.util.Arrays;
import org.fujion.ancillary.IAutoWired;
import org.fujion.annotation.WiredComponent;
import org.fujion.component.BaseComponent;
import org.fujion.highcharts.AlignHorizontal;
import org.fujion.highcharts.AlignVertical;
import org.fujion.highcharts.Axis;
import org.fujion.highcharts.Chart;
import org.fujion.highcharts.Orientation;
import org.fujion.highcharts.PlotLineOptions;
import org.fujion.highcharts.Series;

public class ChartController
implements IAutoWired {
    private static final String[] CATEGORIES = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private static final Double[] TOKYO = new Double[]{7.0, 6.9, 9.5, 14.5, 18.2, 21.5, 25.2, 26.5, 23.3, 18.3, 13.9, 9.6};
    private static final Double[] NEW_YORK = new Double[]{-0.2, 0.8, 5.7, 11.3, 17.0, 22.0, 24.8, 24.1, 20.1, 14.1, 8.6, 2.5};
    private static final Double[] BERLIN = new Double[]{-0.9, 0.6, 3.5, 8.4, 13.5, 17.0, 18.6, 17.9, 14.3, 9.0, 3.9, 1.0};
    private static final Double[] LONDON = new Double[]{3.9, 4.2, 5.7, 8.5, 11.9, 15.2, 17.0, 16.6, 14.2, 10.3, 6.6, 4.8};
    @WiredComponent
    private Chart hchart;

    public void afterInitialized(BaseComponent root) {
        this.hchart.setTitle("Monthly Average Temperature");
        this.hchart.setSubtitle("Source: WorldClimate.com");
        Axis xAxis = this.hchart.getXAxis();
        xAxis.categories.addAll(Arrays.asList(CATEGORIES));
        Axis yAxis = this.hchart.getYAxis();
        yAxis.title.text = "Temperature (\u00b0C)";
        PlotLineOptions plo = new PlotLineOptions();
        yAxis.plotLines.add(plo);
        plo.value = 0.0;
        plo.width = 1;
        plo.color = "#808080";
        this.hchart.options.tooltip.valueSuffix = "\u00b0C";
        this.hchart.options.legend.layout = Orientation.vertical;
        this.hchart.options.legend.align = AlignHorizontal.right;
        this.hchart.options.legend.verticalAlign = AlignVertical.middle;
        this.hchart.options.legend.borderWidth = 0;
        this.addSeries("Tokyo", TOKYO);
        this.addSeries("New York", NEW_YORK);
        this.addSeries("Berlin", BERLIN);
        this.addSeries("London", LONDON);
        this.hchart.run();
    }

    private void addSeries(String name, Double[] data) {
        Series series = this.hchart.addSeries();
        series.name = name;
        for (Double value : data) {
            series.addDataPoint(value.doubleValue());
        }
    }
}

