/*
 * #%L
 * fujion
 * %%
 * Copyright (C) 2008 - 2016 Regenstrief Institute, Inc.
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * #L%
 */
package org.fujion.testharness;

import org.fujion.annotation.EventHandler;
import org.fujion.event.Event;

/**
 * Demonstration of supported server-side scripting engines.
 */
public class ScriptsController extends BaseController {

    @EventHandler(value = "scriptExecution", target = "clojurescript")
    private void clojureExecutionHandler(Event event) {
        log("Clojure script was executed: " + event.getData());
    }

    @EventHandler(value = "scriptExecution", target = "groovyscript")
    private void groovyExecutionHandler(Event event) {
        log("Groovy script was executed: " + event.getData());
    }

    @EventHandler(value = "scriptExecution", target = "jrubyscript")
    private void jrubyExecutionHandler(Event event) {
        log("JRuby script was executed: " + event.getData());
    }

    @EventHandler(value = "scriptExecution", target = "jythonscript")
    private void jythonExecutionHandler(Event event) {
        log("Jython script was executed: " + event.getData());
    }

    @EventHandler(value = "scriptExecution", target = "rscript")
    private void renjinExecutionHandler(Event event) {
        log("Renjin script was executed: " + event.getData());
    }

    @EventHandler(value = "scriptExecution", target = "externalscript")
    private void externalExecutionHandler(Event event) {
        log("External server script was executed: " + event.getData());
    }

}
