/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.testharness;

import org.fujion.annotation.EventHandler;
import org.fujion.annotation.OnFailure;
import org.fujion.annotation.WiredComponent;
import org.fujion.client.ClientUtil;
import org.fujion.component.BaseComponent;
import org.fujion.component.BaseLabeledComponent;
import org.fujion.component.Button;
import org.fujion.component.Caption;
import org.fujion.component.Checkbox;
import org.fujion.component.Detail;
import org.fujion.component.Div;
import org.fujion.component.Popup;
import org.fujion.component.Radiogroup;
import org.fujion.event.ChangeEvent;
import org.fujion.event.Event;
import org.fujion.page.PageUtil;
import org.fujion.testharness.BaseController;

public class MiscController
extends BaseController {
    @WiredComponent(onFailure=OnFailure.IGNORE)
    private Div nomatch;
    @WiredComponent
    private BaseComponent dynamicContent;
    @WiredComponent
    private Popup contextMenu;
    @WiredComponent
    private Div divMaskTest;
    private boolean masked;
    @WiredComponent
    private Button btnToggleBalloon;
    @WiredComponent
    private Caption caption;
    @WiredComponent
    private Radiogroup rgPosition;
    @WiredComponent
    private Radiogroup rgAlignment;
    @WiredComponent
    private Detail detail;

    public void afterInitialized(BaseComponent root) {
        super.afterInitialized(root);
        this.log(this.nomatch == null, "Component 'nomatch' was correctly not wired.", "Component 'nomatch' as erroneously wired.");
        PageUtil.createPageFromContent((String)"<button label='Dynamic Content' class='flavor:btn-danger'/>", (BaseComponent)this.dynamicContent);
    }

    @EventHandler(value={"change"}, target={"chkPreventClosure"})
    public void chkPreventClosureHandler(ChangeEvent event) {
        this.page.setClosable(!((Checkbox)event.getTarget()).isChecked());
    }

    @EventHandler(value={"click"}, target={"btnSaveAsFile"})
    public void btnSaveAsFileHandler() {
        ClientUtil.saveToFile((String)"This is test content", (String)"text/plain", (String)"testFile.txt");
    }

    @EventHandler(value={"click"}, target={"btnMaskTest"})
    private void btnMaskTestClickHandler() {
        this.masked = !this.masked;
        if (this.masked) {
            this.divMaskTest.addMask("Mask Test", this.contextMenu);
        } else {
            this.divMaskTest.removeMask();
        }
    }

    @EventHandler(value={"click"}, target={"@btnToggleBalloon"})
    private void btnToggleBalloonClickHandler() {
        if (this.btnToggleBalloon.getBalloon() == null) {
            this.btnToggleBalloon.setBalloon("Balloon Text");
        } else {
            this.btnToggleBalloon.setBalloon(null);
        }
    }

    @EventHandler(value={"change"}, target={"@rgPosition"})
    private void positionChangeHandler() {
        String value = this.rgPosition.getSelected().getLabel();
        BaseLabeledComponent.LabelPositionAll position = BaseLabeledComponent.LabelPositionAll.valueOf((String)value.toUpperCase());
        this.caption.setPosition(position);
    }

    @EventHandler(value={"change"}, target={"@rgAlignment"})
    private void alignmentChangeHandler() {
        String value = this.rgAlignment.getSelected().getLabel();
        Caption.LabelAlignment alignment = Caption.LabelAlignment.valueOf((String)value.toUpperCase());
        this.caption.setAlignment(alignment);
    }

    @EventHandler(value={"click"}, target={"btnToggleDetail"})
    private void toggleDetailHandler(Event event) {
        this.detail.setOpen(!this.detail.isOpen());
    }
}

