/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.testharness;

import org.fujion.annotation.EventHandler;
import org.fujion.annotation.WiredComponent;
import org.fujion.client.ClientUtil;
import org.fujion.component.BaseComponent;
import org.fujion.component.Div;
import org.fujion.component.Label;
import org.fujion.component.MessagePane;
import org.fujion.component.MessageWindow;
import org.fujion.component.Radiogroup;
import org.fujion.component.Window;
import org.fujion.event.ResizeEvent;
import org.fujion.testharness.BaseController;

public class WindowsController
extends BaseController {
    @WiredComponent(value="^/messagewindow")
    private MessageWindow messagewindow;
    @WiredComponent(value="window1/window_div")
    private Div windowdiv1;
    @WiredComponent(value="window2/window_div")
    private Div windowdiv2;
    @WiredComponent(value="window3")
    private Window window3;
    @WiredComponent(value="window3/rgMode")
    private Radiogroup rgMode;
    private int messageClass = -1;
    private static final String[] MSG_CLASS = new String[]{"success", "warning", "danger", "info"};

    public void afterInitialized(BaseComponent root) {
        super.afterInitialized(root);
        this.log(this.windowdiv1 == null, "Component window1/window_div was NOT autowired.", "Component window1/window_div was autowired.");
        this.log(this.windowdiv2 == null, "Component window2/window_div was NOT autowired.", "Component window2/window_div was autowired.");
        this.log(this.windowdiv1 == this.windowdiv2, "window1/window_div and window2/window_div should not be the same.", null);
    }

    @EventHandler(value={"change"}, target={"window3/rgMode"})
    private void rgModeHandler() {
        Window.Mode newMode = Window.Mode.valueOf((String)this.rgMode.getSelected().getLabel().toUpperCase());
        this.window3.setMode(newMode);
    }

    @EventHandler(value={"click"}, target={"btnAlert"})
    private void btnAlertHandler() {
        ClientUtil.invoke((String)"fujion.alert", (Object[])new Object[]{"This is a test alert", "TEST!", "danger"});
    }

    @EventHandler(value={"click"}, target={"btnMessage"})
    private void btnMessageHandler() {
        MessagePane pane = new MessagePane("Message Title", "category", 8000, false);
        ++this.messageClass;
        this.messageClass = this.messageClass >= MSG_CLASS.length ? 0 : this.messageClass;
        pane.addClass("flavor: alert-" + MSG_CLASS[this.messageClass]);
        pane.addChild((BaseComponent)new Label("This is a test " + MSG_CLASS[this.messageClass] + " message"));
        this.messagewindow.addChild((BaseComponent)pane);
    }

    @EventHandler(value={"resize"}, target={"window3"})
    private void resizeHandler(ResizeEvent event) {
        this.log("Resize event!!!");
    }
}

