/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.testharness;

import org.fujion.annotation.EventHandler;
import org.fujion.annotation.WiredComponent;
import org.fujion.component.BaseComponent;
import org.fujion.component.Doublebox;
import org.fujion.gmaps.GoogleMap;
import org.fujion.gmaps.LatLng;
import org.fujion.gmaps.event.CenterChangeEvent;
import org.fujion.gmaps.event.MapLocationEvent;
import org.fujion.testharness.BaseController;

public class MapsController
extends BaseController {
    @WiredComponent
    private GoogleMap gmap;
    @WiredComponent
    private Doublebox latitude;
    @WiredComponent
    private Doublebox longitude;

    public void afterInitialized(BaseComponent root) {
        super.afterInitialized(root);
        this.updateControls(this.gmap.getCenter());
        this.gmap.run();
    }

    private void updateControls(LatLng location) {
        this.latitude.setValue((Object)location.getLatitude());
        this.longitude.setValue((Object)location.getLongitude());
    }

    @EventHandler(value={"click"}, target={"btnPanTo"})
    private void onClick$btnPanTo() {
        this.gmap.panTo(this.currentPos());
    }

    @EventHandler(value={"gmap_location"}, target={"@gmap"})
    private void onClick$gmap(MapLocationEvent event) {
        this.updateControls(event.getLocation());
    }

    @EventHandler(value={"gmap_center_changed"}, target={"@gmap"})
    private void onTest$gmap(CenterChangeEvent event) {
        this.updateControls(event.getLocation());
    }

    private LatLng currentPos() {
        return new LatLng(((Double)this.latitude.getValue()).doubleValue(), ((Double)this.longitude.getValue()).doubleValue());
    }
}

